// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ConfirmButton;

/// <summary>
/// Test ConfirmOnFormSubmit Mode
/// </summary>
/// <TestSuite>
///   <Path>ConfirmButton\OnSubmit.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ConfirmButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ConfirmButton.OnSubmitPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ConfirmButton.OnSubmit")]
public class ConfirmButton_OnSubmit : AjaxControlToolkit.Testing.Client.ConfirmButton.ConfirmButton_Common
{
    public const string SubmittedResultMessage = "Submitted...";

    public override IEnumerable<ConfirmButtonBehavior> ConfirmButtons
    {
        get { yield return new OnSubmitPage().ConfirmButton; }
    }

    [WebTestMethod]
    public void Confirm()
    {
        OnSubmitPage page = new OnSubmitPage();
        page.ConfirmButton.ConfirmOnFormSubmit.Value = true;
        page.ConfirmButton.ForceConfirmation();
        page.Button.Click(true);
        Assert.AreEqual(SubmittedResultMessage, page.Result.GetAttributes().InnerText);
    }

    [WebTestMethod]
    public void Ignore()
    {
        OnSubmitPage page = new OnSubmitPage();
        page.ConfirmButton.ConfirmOnFormSubmit.Value = false;
        page.ConfirmButton.ForceIgnore();
        page.Button.Click();
        Assert.StringIsNullOrEmpty(page.Result.GetAttributes().InnerText);
    }
}