// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ConfirmButton
{
    /// <summary>
    /// Common ConfirmButton tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.ConfirmButtonBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("ConfirmButton")]
    public abstract class ConfirmButton_Common
    {
        public abstract IEnumerable<ConfirmButtonBehavior> ConfirmButtons
        {
            get;
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_Confirm()
        {
            foreach (ConfirmButtonBehavior confirmButton in ConfirmButtons)
            {
                if (!string.IsNullOrEmpty(confirmButton.DisplayModalPopupID.Value))
                {
                    continue;
                }
                if (String.IsNullOrEmpty(confirmButton.ClickScript.Value))
                {
                    confirmButton.ConfirmOnFormSubmit.Value = false;
                    confirmButton.PreventPostback();
                    confirmButton.AssertConfirmed();
                }
            }
        }

        [WebTestMethod]
        public void Common_Ignore()
        {
            foreach (ConfirmButtonBehavior confirmButton in ConfirmButtons)
            {
                if (!string.IsNullOrEmpty(confirmButton.DisplayModalPopupID.Value))
                {
                    continue;
                }
                confirmButton.AssertIgnored();
            }
        }

        [WebTestMethod]
        public void Common_ChangeConfirmText()
        {
            foreach (ConfirmButtonBehavior confirmButton in ConfirmButtons)
            {
                if (!string.IsNullOrEmpty(confirmButton.DisplayModalPopupID.Value))
                {
                    continue;
                }
                confirmButton.ConfirmText.Value = DateTime.Now.ToLongTimeString();
                confirmButton.AssertIgnored();
            }
        }

        [WebTestMethod]
        public void Common_ButtonDisabled()
        {
            foreach (ConfirmButtonBehavior confirmButton in ConfirmButtons)
            {
                confirmButton.Page.ExecuteScript("$get('" + confirmButton.Element.Id + "').disabled = true");
                confirmButton.Hidden.Register();
                confirmButton.ForceIgnore();
                confirmButton.Element.Click();
                Assert.IsNull(confirmButton.Hidden.Wait(1, false), "Button clicked when disabled!");
            }
        }
    }
}