// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Calendar;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>Calendar\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CalendarBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Calendar.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Calendar.Sample")]
[WebTestTag("SampleWebSite")]
[WebTestTag("Popup")]
public class Calendar_Sample : Calendar_Common
{
    public override IEnumerable<CalendarBehavior> Calendars
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.DefaultCalendar;
            yield return page.CustomCalendar;
            yield return page.ButtonCalendar;
        }
    }
}