// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Make sure that autocomplete timer works right and gets results when the 
/// minimum prefix length is zero.
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\ZeroMinimumPrefixLength.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.ZeroMinimumPrefixLengthPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.ZeroMinimumPrefixLength")]
public class AutoComplete_ZeroMinimumPrefixLength : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get 
        {
            yield return new ZeroMinimumPrefixLengthPage().autoComplete;
        }
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void FlyoutShowsOnFocusWhenLengthIsZero()
    {
        ZeroMinimumPrefixLengthPage page = new ZeroMinimumPrefixLengthPage();
        page.autoComplete.SetTextWaitForFlyout(string.Empty);
    }
}