// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.AnimationExtender Model
    /// </summary>
    /// <TestComponent Name="Animation">
    ///   <ToolkitType>AjaxControlToolkit.AnimationExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.Animation.Animation_Common</CommonTestSuite>
    /// </TestComponent>
    public class AnimationBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// OnLoad
        /// </summary>
        public GenericAnimationBehavior OnLoad
        {
            get { return _onLoad; }
        }
        private GenericAnimationBehavior _onLoad;

        /// <summary>
        /// OnClick
        /// </summary>
        public GenericAnimationBehavior OnClick
        {
            get { return _onClick; }
        }
        private GenericAnimationBehavior _onClick;

        /// <summary>
        /// OnMouseOver
        /// </summary>
        public GenericAnimationBehavior OnMouseOver
        {
            get { return _onMouseOver; }
        }
        private GenericAnimationBehavior _onMouseOver;

        /// <summary>
        /// OnMouseOut
        /// </summary>
        public GenericAnimationBehavior OnMouseOut
        {
            get { return _onMouseOut; }
        }
        private GenericAnimationBehavior _onMouseOut;

        /// <summary>
        /// OnHoverOver
        /// </summary>
        public GenericAnimationBehavior OnHoverOver
        {
            get { return _onHoverOver; }
        }
        private GenericAnimationBehavior _onHoverOver;

        /// <summary>
        /// OnHoverOut
        /// </summary>
        public GenericAnimationBehavior OnHoverOut
        {
            get { return _onHoverOut; }
        }
        private GenericAnimationBehavior _onHoverOut;

        /// <summary>
        /// AjaxControlToolkit.AnimationExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public AnimationBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _onLoad = new GenericAnimationBehavior(element, behaviorID + "_OnLoad",
                string.Format("{0}._onLoad", base.BehaviorReferenceExpression), page);
            _onClick = new GenericAnimationBehavior(element, behaviorID + "_OnClick",
                string.Format("{0}._onClick", base.BehaviorReferenceExpression), page);
            _onMouseOver = new GenericAnimationBehavior(element, behaviorID + "_OnMouseOver",
                string.Format("{0}._onMouseOver", base.BehaviorReferenceExpression), page);
            _onMouseOut = new GenericAnimationBehavior(element, behaviorID + "_OnMouseOut",
                string.Format("{0}._onMouseOut", base.BehaviorReferenceExpression), page);
            _onHoverOver = new GenericAnimationBehavior(element, behaviorID + "_OnHoverOver",
                string.Format("{0}._onHoverOver", base.BehaviorReferenceExpression), page);
            _onHoverOut = new GenericAnimationBehavior(element, behaviorID + "_OnHoverOut",
                string.Format("{0}._onHoverOut", base.BehaviorReferenceExpression), page);
        }
    }
}