// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Accordion;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>Accordion\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AccordionBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Accordion.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Accordion.Sample")]
[WebTestTag("SampleWebSite")]
public class Accordion_Sample : Accordion_Common
{
    public override IEnumerable<AccordionScenario> AccordionScenarios
    {
        get { yield return new AccordionScenario(new SamplePage().Accordion, 3, null); }
    }

    [WebTestFailureTag(Browsers.All, "Would require modification of the demo, which defeats the purpose of copying the Sample page")]
    public override void Common_AutoSizeNone()
    {
        base.Common_AutoSizeNone();
    }
}