<%@ Page
    Language="C#"
    CodeFile="Sample.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.Accordion.Sample" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Accordion - Sample</title>
    <link href="../StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body><form id="form" runat="server"><div>
    <b>Accordion - Sample</b><br />
    SampleWebSite scenario<br /><br /><br />
    
    <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
    
    <ajaxToolkit:Accordion ID="Accordion" runat="server" SelectedIndex="0"
            HeaderCssClass="accordionHeader" HeaderSelectedCssClass="accordionHeaderSelected"
            ContentCssClass="accordionContent" FadeTransitions="false" FramesPerSecond="40" 
            TransitionDuration="250" AutoSize="None" RequireOpenedPane="false" SuppressHeaderPostbacks="true">
            <Panes>
                <ajaxToolkit:AccordionPane ID="AccordionPane1" runat="server">
                    <Header><a href="" class="accordionLink">1. Accordion</a></Header>
                    <Content>
                        The Accordion is a web control that allows you to provide multiple panes and display them one at a time.
                        It is like having several CollapsiblePanels
                        where only one can be expanded at a time.  The Accordion is implemented as a web control that contains
                        AccordionPane web controls. Each AccordionPane control has a template for its Header and its Content.
                        We keep track of the selected pane so it stays visible across postbacks.
                    </Content>
                </ajaxToolkit:AccordionPane>
                <ajaxToolkit:AccordionPane ID="AccordionPane2" runat="server">
                    <Header><a href="" class="accordionLink">2. AutoSize</a></Header>
                    <Content>
                        <p>It also supports three AutoSize modes so it can fit in a variety of layouts.</p>
                        <ul>
                            <li><b>None</b> - The Accordion grows/shrinks without restriction.  This can cause other elements
                                on your page to move up and down with it.</li>
                            <li><b>Limit</b> - The Accordion never grows larger than the value specified by its Height
                                property.  This will cause the content to scroll if it is too large to be displayed.</li>
                            <li><b>Fill</b> - The Accordion always stays the exact same size as its Height property.  This
                                will cause the content to be expanded or shrunk if it isn't the right size.</li>
                        </ul>
                        
                    </Content>
                </ajaxToolkit:AccordionPane>
                <ajaxToolkit:AccordionPane ID="AccordionPane3" runat="server">
                    <Header><a href="" class="accordionLink">3. Control or Extender</a></Header>
                    <Content>
                        The Accordion is written using an extender like most of the other extenders in the AJAX Control Toolkit.
                        The extender expects its input in a very specific hierarchy of container elements (like divs), so
                        the Accordion and AccordionPane web controls are used to generate the expected input for the extender.
                        The extender can also be used on its own if you provide it appropriate input.
                    </Content>
                </ajaxToolkit:AccordionPane>
            </Panes>
        </ajaxToolkit:Accordion>
        
        Fade Transitions: <input id="fade" type="checkbox" onclick="toggleFade();" value="false" /><br />
        AutoSize: <select id="autosize" onchange="changeAutoSize();">
            <option selected="selected">None</option>
            <option>Limit</option>
            <option>Fill</option>
        </select>
        
        <script language="javascript" type="text/javascript">
            function toggleFade() {
                var behavior = $find('Accordion_AccordionExtender');
                if (behavior) {
                    behavior.set_FadeTransitions(!behavior.get_FadeTransitions());
                }
            }
            function changeAutoSize() {
                var behavior = $find('Accordion_AccordionExtender');
                var ctrl = $get('autosize');
                if (behavior) {
                    var size = 'None';
                    switch (ctrl.selectedIndex) {
                        case 0 :
                            behavior.get_element().style.height = 'auto';
                            size = AjaxControlToolkit.AutoSize.None;
                            break;
                        case 1 :
                            behavior.get_element().style.height = '400px';
                            size = AjaxControlToolkit.AutoSize.Limit;
                            break;
                        case 2 :
                            behavior.get_element().style.height = '400px';
                            size = AjaxControlToolkit.AutoSize.Fill;
                            break;
                    }
                    behavior.set_AutoSize(size);
                }
                if (document.focus) {
                    document.focus();
                }
            }
        </script>
</div></form></body>
</html>