// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.TextboxWatermark;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>TextboxWatermark\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.TextboxWatermarkBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.TextboxWatermark.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("TextboxWatermark.Sample")]
[WebTestTag("SampleWebSite")]
public class TextboxWatermark_Sample : TextboxWatermark_Common
{
    public override IEnumerable<TextboxWatermarkScenario> TextboxWatermarkScenarios
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return new TextboxWatermarkScenario(page.TextBoxWatermarkExtender1, page.Button1, page.Label1, "Hello {0} [blank]!", "[blank]", true);
            yield return new TextboxWatermarkScenario(page.TextBoxWatermarkExtender2, page.Button1, page.Label1, "Hello [blank] {0}!", "[blank]", true);
        }
    }
}
