// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Slider;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>Slider\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SliderBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Slider.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Slider.Sample")]
[WebTestTag("SampleWebSite")]
public class Slider_Sample : AjaxControlToolkit.Testing.Client.Slider.Slider_Common
{
    public override IEnumerable<SliderBehavior> Sliders
    {
        get 
        {
            SamplePage page = new SamplePage();
            yield return page.SliderExtender1;
            yield return page.SliderExtender2;
            yield return page.SliderExtender3;
            yield return page.SliderExtender4;
        }
    }

}