// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ReorderList;

/// <summary>
/// ReorderList bound to a DataTable
/// </summary>
/// <TestSuite>
///   <Path>ReorderList\DataTable.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropWatcherBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ReorderList.DataTablePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ReorderList.DataTable")]
public class ReorderList_DataTable : ReorderList_Common
{
    /// <summary>
    /// ReorderLists on the page
    /// </summary>
    public override IEnumerable<DropWatcherBehavior> ReorderLists
    {
        get { yield return new DataTablePage().ReorderList; }
    }
}