// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.PopupControl
{
    /// <summary>
    /// Simple class to represent a PopupControl scenario
    /// </summary>
    public class PopupControlScenario
    {
        public PopupControlBehavior PopupControlBehavior
        {
            get { return _popupControlBehavior; }
        }
        private PopupControlBehavior _popupControlBehavior;

        public HtmlInputElement Element
        {
            get { return _popupControlBehavior.Element as HtmlInputElement; }
        }

        public HtmlElement Popup
        {
            get { return _popup; }
        }
        private HtmlElement _popup;

        public HtmlInputElement Commit
        {
            get { return _commit; }
        }
        private HtmlInputElement _commit;

        public HtmlInputElement Clear
        {
            get { return _clear; }
        }
        private HtmlInputElement _clear;

        public HtmlInputElement Cancel
        {
            get { return _cancel; }
        }
        private HtmlInputElement _cancel;

        public HtmlInputElement CommitCancel
        {
            get { return _commitCancel; }
        }
        private HtmlInputElement _commitCancel;

        public HtmlInputElement CancelCommit
        {
            get { return _cancelCommit; }
        }
        private HtmlInputElement _cancelCommit;

        public PopupControlScenario(PopupControlBehavior popupControlBehavior, HtmlElement popup, HtmlInputElement commit, HtmlInputElement clear, HtmlInputElement cancel, HtmlInputElement commitCancel, HtmlInputElement cancelCommit)
        {
            Assert.IsNotNull(popupControlBehavior);
            _popupControlBehavior = popupControlBehavior;
            Assert.IsNotNull(popup);
            _popup = popup;

            _commit = commit;
            _clear = clear;
            _cancel = cancel;
            _commitCancel = commitCancel;
            _cancelCommit = cancelCommit;
        }
    }
}
