// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System.Collections.Generic;
using AjaxControlToolkit.Testing.Client.MultiHandleSlider;
using Microsoft.Web.Testing;
using AjaxControlToolkit.Testing.Client;

/// <summary>
/// Test to ensure that a slider that does not have a bound 
/// textbox works fine. This is a basic slider scenario.
/// </summary>
/// <TestSuite>
///   <Path>MultiHandleSlider\MultiHandleSliderWithNoBoundTextBox.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.MultiHandleSliderBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.MultiHandleSlider.MultiHandleSliderWithNoBoundTextBoxPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("MultiHandleSlider.MultiHandleSliderWithNoBoundTextBox")]
public class MultiHandleSlider_SliderWithNoBoundTextBox : MultiHandleSlider_Common
{
    public override IEnumerable<MultiHandleSliderBehavior> BackCompatSliders
    {
        get 
        {
            yield return new MultiHandleSliderWithNoBoundTextBoxPage().sliderExtender;
        }
    }
}