// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ModalPopup;

/// <summary>
/// Make sure that the modal popup dynamic populate control gets populated correctly.
/// </summary>
/// <TestSuite>
///   <Path>ModalPopup\DynamicPopulate.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ModalPopupBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ModalPopup.DynamicPopulatePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ModalPopup.DynamicPopulate")]
public class ModalPopup_DynamicPopulate : AjaxControlToolkit.Testing.Client.ModalPopup.ModalPopup_Common
{
    public override IEnumerable<ModalPopupBehavior> ModalPopups
    {
        get 
        {
            yield return new DynamicPopulatePage().ModalPopupExtender1;
        }
    }

    [WebTestMethod]
    public void ValidateDynamicPopulate()
    {
        DynamicPopulatePage page = new DynamicPopulatePage();
        page.ModalPopupExtender1.ShowPopup();
        Assert.AreEqual(page.Label2.Id, page.ModalPopupExtender1.DynamicControl.Reference.Id);
        Common.Wait(page, 3,
            delegate()
            {
                return (String.Compare(page.ModalPopupExtender1.DynamicContextKey.Value, page.Label2.GetAttributes().InnerText) == 0);
            });
    }
}