// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.MaskedEditExtender Model
    /// </summary>
    /// <TestComponent Name="MaskedEdit">
    ///   <ToolkitType>AjaxControlToolkit.MaskedEditExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.MaskedEdit.MaskedEdit_Common</CommonTestSuite>
    /// </TestComponent>
    public class MaskedEditBehavior : Behavior<HtmlInputElement>
    {
        /// <summary>
        /// Mask
        /// </summary>
        public BehaviorProperty<string> Mask
        {
            get { return _mask; }
        }
        private BehaviorProperty<string> _mask;

        /// <summary>
        /// ClipboardText
        /// </summary>
        public BehaviorProperty<string> ClipboardText
        {
            get { return _clipboardText; }
        }
        private BehaviorProperty<string> _clipboardText;

        /// <summary>
        /// MaskType
        /// </summary>
        public BehaviorProperty<MaskedEditType> MaskType
        {
            get { return _maskType; }
        }
        private BehaviorProperty<MaskedEditType> _maskType;

        /// <summary>
        /// MessageValidatorTip
        /// </summary>
        public BehaviorProperty<bool> MessageValidatorTip
        {
            get { return _messageValidatorTip; }
        }
        private BehaviorProperty<bool> _messageValidatorTip;

        /// <summary>
        /// ErrorTooltipEnabled
        /// </summary>
        public BehaviorProperty<bool> ErrorTooltipEnabled
        {
            get { return _errorTooltipEnabled; }
        }
        private BehaviorProperty<bool> _errorTooltipEnabled;

        /// <summary>
        /// ErrorTooltipCssClass
        /// </summary>
        public BehaviorProperty<string> ErrorTooltipCssClass
        {
            get { return _errorTooltipCssClass; }
        }
        private BehaviorProperty<string> _errorTooltipCssClass;

        /// <summary>
        /// ClipboardEnabled
        /// </summary>
        public BehaviorProperty<bool> ClipboardEnabled
        {
            get { return _clipboardEnabled; }
        }
        private BehaviorProperty<bool> _clipboardEnabled;

        /// <summary>
        /// AutoComplete
        /// </summary>
        public BehaviorProperty<bool> AutoComplete
        {
            get { return _autoComplete; }
        }
        private BehaviorProperty<bool> _autoComplete;

        /// <summary>
        /// ClearTextOnInvalid
        /// </summary>
        public BehaviorProperty<bool> ClearTextOnInvalid
        {
            get { return _clearTextOnInvalid; }
        }
        private BehaviorProperty<bool> _clearTextOnInvalid;

        /// <summary>
        /// AutoCompleteValue
        /// </summary>
        public BehaviorProperty<string> AutoCompleteValue
        {
            get { return _autoCompleteValue; }
        }
        private BehaviorProperty<string> _autoCompleteValue;

        /// <summary>
        /// Filtered
        /// </summary>
        public BehaviorProperty<string> Filtered
        {
            get { return _filtered; }
        }
        private BehaviorProperty<string> _filtered;

        /// <summary>
        /// InputDirection
        /// </summary>
        public BehaviorProperty<MaskedEditInputDirection> InputDirection
        {
            get { return _inputDirection; }
        }
        private BehaviorProperty<MaskedEditInputDirection> _inputDirection;

        /// <summary>
        /// PromptCharacter
        /// </summary>
        public BehaviorProperty<string> PromptCharacter
        {
            get { return _promptCharacter; }
        }
        private BehaviorProperty<string> _promptCharacter;

        /// <summary>
        /// OnFocusCssClass
        /// </summary>
        public BehaviorProperty<string> OnFocusCssClass
        {
            get { return _onFocusCssClass; }
        }
        private BehaviorProperty<string> _onFocusCssClass;

        /// <summary>
        /// OnInvalidCssClass
        /// </summary>
        public BehaviorProperty<string> OnInvalidCssClass
        {
            get { return _onInvalidCssClass; }
        }
        private BehaviorProperty<string> _onInvalidCssClass;

        /// <summary>
        /// UserDateFormat
        /// </summary>
        public BehaviorProperty<MaskedEditUserDateFormat> UserDateFormat
        {
            get { return _userDateFormat; }
        }
        private BehaviorProperty<MaskedEditUserDateFormat> _userDateFormat;

        /// <summary>
        /// UserTimeFormat
        /// </summary>
        public BehaviorProperty<MaskedEditUserTimeFormat> UserTimeFormat
        {
            get { return _userTimeFormat; }
        }
        private BehaviorProperty<MaskedEditUserTimeFormat> _userTimeFormat;

        /// <summary>
        /// ClearMaskOnLostFocus
        /// </summary>
        public BehaviorProperty<bool> ClearMaskOnLostFocus
        {
            get { return _clearMaskOnLostFocus; }
        }
        private BehaviorProperty<bool> _clearMaskOnLostFocus;

        /// <summary>
        /// CultureName
        /// </summary>
        public BehaviorProperty<string> CultureName
        {
            get { return _cultureName; }
        }
        private BehaviorProperty<string> _cultureName;

        /// <summary>
        /// CultureDatePlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureDatePlaceholder
        {
            get { return _cultureDatePlaceholder; }
        }
        private BehaviorProperty<string> _cultureDatePlaceholder;

        /// <summary>
        /// CultureTimePlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureTimePlaceholder
        {
            get { return _cultureTimePlaceholder; }
        }
        private BehaviorProperty<string> _cultureTimePlaceholder;

        /// <summary>
        /// CultureDecimalPlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureDecimalPlaceholder
        {
            get { return _cultureDecimalPlaceholder; }
        }
        private BehaviorProperty<string> _cultureDecimalPlaceholder;

        /// <summary>
        /// CultureThousandsPlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureThousandsPlaceholder
        {
            get { return _cultureThousandsPlaceholder; }
        }
        private BehaviorProperty<string> _cultureThousandsPlaceholder;

        /// <summary>
        /// CultureDateFormat
        /// </summary>
        public BehaviorProperty<string> CultureDateFormat
        {
            get { return _cultureDateFormat; }
        }
        private BehaviorProperty<string> _cultureDateFormat;

        /// <summary>
        /// CultureCurrencySymbolPlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureCurrencySymbolPlaceholder
        {
            get { return _cultureCurrencySymbolPlaceholder; }
        }
        private BehaviorProperty<string> _cultureCurrencySymbolPlaceholder;

        /// <summary>
        /// CultureAMPMPlaceholder
        /// </summary>
        public BehaviorProperty<string> CultureAMPMPlaceholder
        {
            get { return _cultureAMPMPlaceholder; }
        }
        private BehaviorProperty<string> _cultureAMPMPlaceholder;

        /// <summary>
        /// AcceptAMPM
        /// </summary>
        public BehaviorProperty<bool> AcceptAMPM
        {
            get { return _acceptAMPM; }
        }
        private BehaviorProperty<bool> _acceptAMPM;

        /// <summary>
        /// AcceptNegative
        /// </summary>
        public BehaviorProperty<MaskedEditShowSymbol> AcceptNegative
        {
            get { return _acceptNegative; }
        }
        private BehaviorProperty<MaskedEditShowSymbol> _acceptNegative;

        /// <summary>
        /// OnFocusCssNegative
        /// </summary>
        public BehaviorProperty<string> OnFocusCssNegative
        {
            get { return _onFocusCssNegative; }
        }
        private BehaviorProperty<string> _onFocusCssNegative;

        /// <summary>
        /// OnBlurCssNegative
        /// </summary>
        public BehaviorProperty<string> OnBlurCssNegative
        {
            get { return _onBlurCssNegative; }
        }
        private BehaviorProperty<string> _onBlurCssNegative;

        /// <summary>
        /// DisplayMoney
        /// </summary>
        public BehaviorProperty<MaskedEditShowSymbol> DisplayMoney
        {
            get { return _displayMoney; }
        }
        private BehaviorProperty<MaskedEditShowSymbol> _displayMoney;

        /// <summary>
        /// Century
        /// </summary>
        public BehaviorProperty<int> Century
        {
            get { return _century; }
        }
        private BehaviorProperty<int> _century;

        /// <summary>
        /// AjaxControlToolkit.MaskedEditExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public MaskedEditBehavior(HtmlInputElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _mask = BehaviorProperty<string>.CreateProperty(this, "Mask");
            _clipboardText = BehaviorProperty<string>.CreateProperty(this, "ClipboardText");
            _maskType = BehaviorProperty<MaskedEditType>.CreateProperty(this, "MaskType");
            _messageValidatorTip = BehaviorProperty<bool>.CreateProperty(this, "MessageValidatorTip");
            _errorTooltipEnabled = BehaviorProperty<bool>.CreateProperty(this, "ErrorTooltipEnabled");
            _errorTooltipCssClass = BehaviorProperty<string>.CreateProperty(this, "ErrorTooltipCssClass");
            _clipboardEnabled = BehaviorProperty<bool>.CreateProperty(this, "ClipboardEnabled");
            _autoComplete = BehaviorProperty<bool>.CreateProperty(this, "AutoComplete");
            _clearTextOnInvalid = BehaviorProperty<bool>.CreateProperty(this, "ClearTextOnInvalid");
            _autoCompleteValue = BehaviorProperty<string>.CreateProperty(this, "AutoCompleteValue");
            _filtered = BehaviorProperty<string>.CreateProperty(this, "Filtered");
            _inputDirection = BehaviorProperty<MaskedEditInputDirection>.CreateProperty(this, "InputDirection");
            _promptCharacter = BehaviorProperty<string>.CreateProperty(this, "PromptCharacter");
            _onFocusCssClass = BehaviorProperty<string>.CreateProperty(this, "OnFocusCssClass");
            _onInvalidCssClass = BehaviorProperty<string>.CreateProperty(this, "OnInvalidCssClass");
            _userDateFormat = BehaviorProperty<MaskedEditUserDateFormat>.CreateProperty(this, "UserDateFormat");
            _userTimeFormat = BehaviorProperty<MaskedEditUserTimeFormat>.CreateProperty(this, "UserTimeFormat");
            _clearMaskOnLostFocus = BehaviorProperty<bool>.CreateProperty(this, "ClearMaskOnLostFocus");
            _cultureName = BehaviorProperty<string>.CreateProperty(this, "CultureName");
            _cultureDatePlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureDatePlaceholder");
            _cultureTimePlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureTimePlaceholder");
            _cultureDecimalPlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureDecimalPlaceholder");
            _cultureThousandsPlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureThousandsPlaceholder");
            _cultureDateFormat = BehaviorProperty<string>.CreateProperty(this, "CultureDateFormat");
            _cultureCurrencySymbolPlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureCurrencySymbolPlaceholder");
            _cultureAMPMPlaceholder = BehaviorProperty<string>.CreateProperty(this, "CultureAMPMPlaceholder");
            _acceptAMPM = BehaviorProperty<bool>.CreateProperty(this, "AcceptAMPM");
            _acceptNegative = BehaviorProperty<MaskedEditShowSymbol>.CreateProperty(this, "AcceptNegative");
            _onFocusCssNegative = BehaviorProperty<string>.CreateProperty(this, "OnFocusCssNegative");
            _onBlurCssNegative = BehaviorProperty<string>.CreateProperty(this, "OnBlurCssNegative");
            _displayMoney = BehaviorProperty<MaskedEditShowSymbol>.CreateProperty(this, "DisplayMoney");
            _century = BehaviorProperty<int>.CreateProperty(this, "Century");
        }
    }
}