// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DropShadow;

/// <summary>
/// Simple drop shadow test
/// </summary>
/// <TestSuite>
///   <Path>DropShadow\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropShadowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DropShadow.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DropShadow.Simple")]
public class DropShadow_Simple : AjaxControlToolkit.Testing.Client.DropShadow.DropShadow_Common
{
    public override IEnumerable<DropShadowBehavior> DropShadows
    {
        get { yield return new SimplePage().DropShadow; }
    }

    [WebTestMethod]
    public void InitialValues()
    {
        SimplePage page = new SimplePage();
        Assert.IsTrue(page.DropShadow.ElementBounds.Value.X > 0);
        Assert.IsTrue(page.DropShadow.ElementBounds.Value.Y > 0);
        page.DropShadow.AssertBounds();
        Assert.AreEqual(0.2f, page.DropShadow.Opacity.Value);
    }

    [WebTestMethod]
    public void Shrink()
    {
        SimplePage page = new SimplePage();
        page.DropShadow.AssertBounds();
        page.DropShadow.TrackPosition.Value = true;
        page.DropShadow.TrackPositionDelay.Value = 25;
        page.ExecuteScript("$get('" + page.MoreText.Id + "').style.display = 'none'");
        page.DropShadow.WaitForBounds(3);
    }
}