// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CollapsiblePanel;

/// <summary>
/// Simple tests of a CollapsiblePanel with a horizontal expand direction
/// </summary>
/// <TestSuite>
///   <Path>CollapsiblePanel\Horizontal.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CollapsiblePanelBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CollapsiblePanel.HorizontalPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CollapsiblePanel.Horizontal")]
public class CollapsiblePanel_Horizontal : CollapsiblePanel_Common
{
    public override IEnumerable<CollapsiblePanelBehavior> CollapsiblePanels
    {
        get { yield return (new HorizontalPage()).CollapsiblePanel; }
    }

    public override bool SupportsPostback
    {
        get { return true; }
    }

    public override void DoPostback(CollapsiblePanelBehavior collapsiblePanel)
    {
        HorizontalPage page = collapsiblePanel.Page as HorizontalPage;
        Assert.IsNotNull(page, "collapsiblePanel.Page must be of type HorizontalPage!");

        page.Button.Click(true);
        page.Invalidate();
    }
}