// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.CascadingDropDown;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>CascadingDropDown\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CascadingDropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.CascadingDropDown.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("CascadingDropDown.Sample")]
[WebTestTag("SampleWebSite")]
public class CascadingDropDown_Sample : AjaxControlToolkit.Testing.Client.CascadingDropDown.CascadingDropDown_Common
{
    [WebTestMethod]
    public void Surfing()
    {
        SamplePage page = new SamplePage();
        RegisterForSelectionChanged(page.CascadingDropDown1, page.CascadingDropDown2, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown1);

        page.CascadingDropDown1.AssertPopulationCorrect(0, _optionInformationsMake);
        AssertDropDownsDisabled(page.CascadingDropDown2, page.CascadingDropDown3);

        page.CascadingDropDown1.SetSelectedIndex(3, page.CascadingDropDown2, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown2);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel);
        AssertDropDownsDisabled(page.CascadingDropDown3);

        page.CascadingDropDown2.SetSelectedIndex(2, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel5series);

        page.CascadingDropDown3.SetSelectedIndex(1, page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(2, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(1, _optionInformationsMakeBmwModel5series);
        page.Label1.WaitForInnerText("You have chosen a Yellow BMW 5 series. Nice car!", 3);

        page.CascadingDropDown2.SetSelectedIndex(1, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(1, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(0, _optionInformationsMakeBmwModel3series);

        page.CascadingDropDown3.SetSelectedIndex(3, page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(3, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(1, _optionInformationsMakeBmwModel);
        page.CascadingDropDown3.AssertPopulationCorrect(3, _optionInformationsMakeBmwModel3series);
        page.Label1.WaitForInnerText("You have chosen a Racing Blue BMW 3 series. Nice car!", 3);

        page.CascadingDropDown1.SetSelectedIndex(2, page.CascadingDropDown2, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown2);
        page.CascadingDropDown1.AssertPopulationCorrect(2, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(0, _optionInformationsMakeAudiModel);
        AssertDropDownsDisabled(page.CascadingDropDown3);

        page.CascadingDropDown2.SetSelectedIndex(1, page.CascadingDropDown3);
        WaitForPopulation(page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(2, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(1, _optionInformationsMakeAudiModel);
        page.CascadingDropDown3.AssertPopulationCorrect(0, _optionInformationsMakeAudiModelA4);

        page.CascadingDropDown3.SetSelectedIndex(1, page.CascadingDropDown3);
        page.CascadingDropDown1.AssertPopulationCorrect(2, _optionInformationsMake);
        page.CascadingDropDown2.AssertPopulationCorrect(1, _optionInformationsMakeAudiModel);
        page.CascadingDropDown3.AssertPopulationCorrect(1, _optionInformationsMakeAudiModelA4);
        page.Label1.WaitForInnerText("You have chosen a Azure Audi A4. Nice car!", 3);
    }
}
