// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Globalization;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Calendar;

/// <summary>
/// Test a calendar localized with hi-in
/// </summary>
/// <TestSuite>
///   <Path>Calendar\Localized.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.CalendarBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Calendar.LocalizedPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Calendar.Localized")]
[WebTestTag("Popup")]
public class Calendar_Localized : Calendar_Common
{
    /// <summary>
    /// Calendars on the page
    /// </summary>
    public override IEnumerable<CalendarBehavior> Calendars
    {
        get
        {
            CalendarBehavior calendar = new LocalizedPage().Calendar;
            calendar.Culture = CultureInfo.CreateSpecificCulture("hi-in");
            yield return calendar;
        }
    }
}