using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Reflection;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Drawing.Design;
using System.Security.Permissions;
using System.Collections;
using System.Collections.ObjectModel;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml;
using System.Xml.Schema;
using System.Globalization;
using System.CodeDom;
using System.Drawing;
using System.IO;
using AjaxControlToolkit;

#region [ Resources ]

[assembly: WebResource("AjaxControlToolkit.HTMLEditor.Images.ed_sep.gif", "image/gif")]
[assembly: WebResource("AjaxControlToolkit.HTMLEditor.Toolbar_buttons.HorizontalSeparator.js", "application/x-javascript")]

#endregion

namespace AjaxControlToolkit.HTMLEditor.ToolbarButton
{
    [ToolboxItem(false)]
    [ParseChildren(true)]
    [PersistChildren(false)]
    [RequiredScript(typeof(CommonToolkitScripts))]
    [ClientScriptResource("AjaxControlToolkit.HTMLEditor.ToolbarButton.HorizontalSeparator", "AjaxControlToolkit.HTMLEditor.Toolbar_buttons.HorizontalSeparator.js")]
    public class HorizontalSeparator : DesignModeImageButton
    {
        #region [ Methods ]

        protected override void OnPreRender(EventArgs e)
        {
            RegisterButtonImages("ed_sep");
            base.OnPreRender(e);
        }

        protected override Style CreateControlStyle()
        {
            HorizontalSeparatorStyle style = new HorizontalSeparatorStyle(ViewState);
            return style;
        }

        #endregion

        #region [ HorizontalSeparatorStyle ]

        private sealed class HorizontalSeparatorStyle : Style
        {
            public HorizontalSeparatorStyle(StateBag state)
                : base(state)
            {
            }

            protected override void FillStyleAttributes(CssStyleCollection attributes, IUrlResolutionService urlResolver)
            {
                base.FillStyleAttributes(attributes, urlResolver);

                attributes.Add("background-color", "transparent");
                attributes.Add("cursor", "text");
            }
        }

        #endregion
    }
}
