<%@ Page
    Language="C#"
    CodeFile="TestStatus.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.TestStatus" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>AJAX Control Toolkit Automated Client-Side Testing</title>
    <style type="text/css">
        body
        {
            font-size: 7pt;
            font-family: Verdana;
        }
        
        table
        {
            height: 100%;
            padding: 0px;
            margin: 0px;
        }
        
        h1
        {
            font-size: 16pt;
            font-family: Tahoma;
            font-weight: bold;
            padding-top: 10px;
        }
        
        #frame
        {
            margin: 3px 5px 3px 5px;
            background-color: #FFFFE1;
        }
        
        #btnRun
        {
            font-size: 6.5pt;
            height: 18px;
        }
        
        #cmbVerbosity
        {
            font-size: 6.5pt;
            height: 18px;
        }
        
        #status
        {
            visibility: hidden;
        }

        .option
        {
            height: 21px;
            font-size: 6.5pt;
        }
        
        #progressBar
        {
            background-color: #FFFFFF;
            border: 1px solid #000000;
            height: 16px;
            width: 95%;
            padding: 0px;
            margin: 0px;
            text-align: left;
        }
        
        #progress
        {
            position: relative;
            top: 0px;
            left: 0px;
            height: 100%;
            
            
            text-align: right;
            overflow: hidden;
        
            font-family: Tahoma, Arial;
            font-weight: bolder;
            font-size: 12px;
            padding: 0px;
            margin: 0px;
        }
        
        #progressValue
        {
        }
        
        #progressPercent
        {
            font-size: 8px;
            font-weight: normal;
            vertical-align: text-top;
        }
        
        #failureCount
        {
            font-weight: bold;
            color: #FF0000;
        }
        
        .success
        {
            background-color: #00FF00;
            color: #000000;
        }
        
        .failure
        {
            background-color: #FF0000;
            color: #FFFFFF;
        }
    </style>
    <script type="text/javascript">
        function onClick(btn) {
            if (!parent.testDriver.TestExecutor || !parent.testDriver.clickRunTests) {
                window.setTimeout(function() { onClick(btn); }, 100);
                return;
            }
            parent.testDriver.clickRunTests(btn);
            return false;
        }
        
        function toggleSync(checkbox) {
            if (!parent.testDriver.TestExecutor || !parent.testDriver.toggleSyncLogs) {
                window.setTimeout(function() { toggleSync(checkbox); }, 100);
                return;
            }
            parent.testDriver.toggleSyncLogs(checkbox);
        }
    </script>
</head>
<body id="frame"><form runat="server"><div>
    <table cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td class="option" width="80"><asp:Button ID="btnRun" runat="server" Text="Run Tests" OnClientClick="onClick(this);" UseSubmitBehavior="true" /></td>
            <td class="option" width="135"><asp:CheckBox ID="chkSkipFail" runat="server" Text="Skip Known Failures" /></td>
            <td rowspan="3">
                <div id="status">
                    <table cellpadding="0" cellspacing="0" width="99%">
                        <tr>
                            <td width="50%"><nobr><asp:Label ID="lblThread" runat="server" Text="Stopped"/></nobr></td>
                            <td width="50%" align="right"><nobr><asp:Label ID="lblTimer" runat="server" /></nobr></td>
                        </tr>
                        <tr>
                            <td valign="middle" colspan="2">
                                <center>
                                    <div id="progressBar">
                                        <div id="progress" class="success"><span id="progressValue"></span><span id="progressPercent">%</span></div>
                                    </div>
                                </center>
                            </td>
                        </tr>
                        <tr>
                            <td><div id="failureCount"><nobr><asp:Label ID="lblFailures" runat="server" />&nbsp;Failure(s)</nobr></div></td>
                            <td align="right"><nobr><asp:Label ID="lblCount" runat="server" />&nbsp;of&nbsp;<asp:Label ID="lblTotal" runat="server" /></nobr></td>
                        </tr>
                        <tr>
                            <td colspan="2" align="center" style="overflow: hidden;"><nobr><asp:Label ID="lblTestId" runat="server" /></nobr></td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
        <tr>
            <td class="option" valign="bottom">Log Detail:</td>
            <td class="option"><asp:CheckBox ID="chkFilter" runat="server" Text="Hide Unchecked Tests" /></td>
        </tr>
        <tr>
            <td class="option">
                <asp:DropDownList ID="cmbVerbosity" runat="server">
                    <asp:ListItem Text="Concise" />
                    <asp:ListItem Text="Standard" Selected="true" />
                    <asp:ListItem Text="Verbose" />
                </asp:DropDownList>
            </td>
            <td class="option"><asp:CheckBox ID="chkSync" runat="server" Text="Sync Logs" onclick="toggleSync(this);" /></td>
        </tr>
    </table>
</div></form></body>
</html>