<%@ Page Language="C#" CodeFile="ContextKey.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.SlideShow.ContextKey" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>SlideShow - ContextKey</title>

    <script type="text/javascript">
    function updateSlideShow(place) {
        if(!place) {
            var location = $get('Location');
            var selectedIndex = location.selectedIndex;
            place  = location.options[selectedIndex].text;
        }
        var slideShow = $find('slideShowBehavior');
        slideShow.set_contextKey(place);

    }
    </script>

</head>
<body>
    <form id="form" runat="server">
        <div>
            <b>SlideShow - ContextKey</b><br />
            Ensure that updating the context key resets the SlideShow correctly.<br />
            <br />
            <br />
            <br />
            <select id="Location">
                <option selected="selected">Venice</option>
                <option>Positano</option>
                <option>Capri</option>
            </select>
            <input type="button" value="View Photos" onclick="updateSlideShow()" />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
            <div style="float: left">
                <asp:Button runat="Server" ID="prevButton" Text="Prev" Font-Size="Larger" />
                <asp:Button runat="Server" ID="playButton" Text="Play" Font-Size="Larger" />
                <asp:Button runat="Server" ID="nextButton" Text="Next" Font-Size="Larger" />
                <asp:Image runat="Server" ID="SlideShowImage" Height="400" ImageUrl="~/SlideShow/images/Venice7.jpg" />
            </div>
            <ajaxToolkit:SlideShowExtender runat="Server" ID="SlideShowExtender" TargetControlID="SlideShowImage"
                SlideShowServiceMethod="GetSlidesWithContext" BehaviorID="slideShowBehavior"
                AutoPlay="false" UseContextKey="true" ContextKey="Venice" NextButtonID="nextButton"
                PreviousButtonID="prevButton" PlayButtonID="playButton">
            </ajaxToolkit:SlideShowExtender>
            <br />
        </div>
    </form>
</body>
</html>
