<%@ Page Language="C#" CodeFile="Callbacks.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.Rating.Callbacks" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Rating - Callbacks</title>
    <style type="text/css">
        .ratingStar
        {
            font-size: 0pt;
            width: 13px;
            height: 12px;
            margin: 0px;
            padding: 0px;
            cursor: pointer;
            display: block;
            background-repeat: no-repeat;
        }
        .filledRatingStar { background-image: url(Images/FilledStar.png); }
        .emptyRatingStar { background-image: url(Images/EmptyStar.png); }
        .savedRatingStar { background-image: url(Images/SavedStar.png); }
    </style>
</head>
<body>
<script type="text/javascript">
        
        var _eventOk = false;
        var _eventCallBackOk = false;
        var _resultFromServerSide = '';
        
        function onRatingChange(sender, eventArgs) {
            _eventOk = true;
        }
        
        function onEndClientCallBack(sender, eventArgs) {
            _eventCallBackOk = true;
            _resultFromServerSide = eventArgs.get_CallbackResult();
        }
        
        function pageLoad() {
            _eventOk = false;
            _eventCallBackOk = false;
            var _rating1Extender = $find('Rating1_RatingExtender');
            _rating1Extender.add_Rated(onRatingChange);
            _rating1Extender.add_EndClientCallback(onEndClientCallBack);
        }
</script>
    <form id="form" runat="server">
        <div>
            <b>Rating - Callbacks</b><br />
            Validate that rating callbacks work fine<br />
            <br />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
            <ajaxToolkit:Rating ID="Rating1" runat="server" CurrentRating="5" MaxRating="10"
                ReadOnly="false" StarCssClass="ratingStar" WaitingStarCssClass="savedRatingStar"
                FilledStarCssClass="filledRatingStar" EmptyStarCssClass="emptyRatingStar" Tag="99" 
                OnChanged="Rating1_Changed">
            </ajaxToolkit:Rating>
            
            <br />
            <br />
        </div>
    </form>
</body>
</html>
