// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.AutoComplete
{
    /// <summary>
    /// Test that validates that delimiters set on an autocompleteextender allow users to complete the last word typed instead
    /// of the entire text in the textbox.
    /// </summary>
    public partial class MultiWordTest : Page
    {
        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static string[] GetLastWordToComplete(string prefixText, int count)
        {
            string[] suggestions = new string[count];
            for (int i = 0; i < count; ++i)
            {
                suggestions[i] = prefixText + i;
            }
            return suggestions;
        }
    }
}