// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.TextboxWatermark;

/// <summary>
/// Core tests for TextboxWatermark
/// </summary>
/// <TestSuite>
///   <Path>TextboxWatermark\Core.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.TextboxWatermarkBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.TextboxWatermark.CorePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("TextboxWatermark.Core")]
public class TextboxWatermark_Core : AjaxControlToolkit.Testing.Client.TextboxWatermark.TextboxWatermark_Common
{
    public override IEnumerable<TextboxWatermarkScenario> TextboxWatermarkScenarios
    {
        get
        {
            CorePage page = new CorePage();
            yield return new TextboxWatermarkScenario(page.TextBoxWatermark, page.Button, page.Label, ":{0}:", "", false);
        }
    }
}
