// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PopupControl;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>PopupControl\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PopupControlBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PopupControl.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PopupControl.Sample")]
[WebTestTag("SampleWebSite")]
public class PopupControl_Sample : PopupControl_Common
{
    public override IEnumerable<PopupControlScenario> PopupControlScenarios
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return new PopupControlScenario(page.PopupControlExtender1, page.Panel1, null, null, null, null, null);
            yield return new PopupControlScenario(page.PopupControlExtender2, page.Panel2, null, null, null, null, null);
        }
    }

    // TODO: Add more focused testing
}
