// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Hover;

/// <summary>
/// Make sure that scripts set to run on hover/unhover run as expected
/// </summary>
/// <TestSuite>
///   <Path>Hover\HoverUnHoverScripts.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.HoverBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Hover.HoverUnHoverScriptsPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Hover.HoverUnHoverScripts")]
public class Hover_HoverUnHoverScripts : AjaxControlToolkit.Testing.Client.Hover.Hover_Common
{
    [WebTestMethod]
    public void ValidateHoverAndUnHoverScriptsExecute()
    {
        HoverUnHoverScriptsPage page = new HoverUnHoverScriptsPage();
        HoverBehavior behavior = page.hoverExtender;
        HtmlElement label = page.hoverScriptTarget;
        behavior.HoverOver();
        Assert.AreEqual("OnHover", label.GetAttributes().InnerText);
        behavior.HoverOut();
        Assert.AreEqual("OnUnHover", label.GetAttributes().InnerText);
    }
}