// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Make sure that ContextKey is passed correctly to the AutoComplete webservice
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\ContextKey.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.ContextKeyPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.ContextKey")]
public class AutoComplete_ContextKey : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get 
        {
            yield return new ContextKeyPage().AutoCompleteExtender2;
        }
    }
    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void ChangeContextKeyAndValidate()
    {
        ContextKeyPage page = new ContextKeyPage();
        AutoCompleteBehavior autocomplete = page.AutoCompleteExtender2;
        autocomplete.SetTextWaitForFlyout("donkey");
        autocomplete.ChooseOption(5);
        Assert.StringEndsWith(page.TextBox2.GetAttributes().Value, autocomplete.ContextKey.Value);
        autocomplete.ContextKey.Value = "Fooooooo";
        autocomplete.SetTextWaitForFlyout("donkey");
        autocomplete.ChooseOption(4);
        Assert.StringEndsWith(page.TextBox2.GetAttributes().Value, autocomplete.ContextKey.Value);
    }
}