// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ValidatorCallout
{
    public class ValidatorCalloutScenario
    {
        public ValidatorCalloutBehavior Behavior
        {
            get { return _behavior; }
        }
        private ValidatorCalloutBehavior _behavior;

        public HtmlInputElement TextBox
        {
            get { return _textBox; }
        }
        private HtmlInputElement _textBox;

        public string InvalidText
        {
            get { return _invalidText; }
        }
        private string _invalidText;

        public string ValidText
        {
            get { return _validText; }
        }
        private string _validText;

        public HtmlElement Button
        {
            get { return _button; }
        }
        private HtmlElement _button;

        public bool WaitForPostbackValid
        {
            get { return _waitForPostbackValid; }
        }
        private bool _waitForPostbackValid;

        public bool WaitForPostbackInvalid
        {
            get { return _waitForPostbackInvalid; }
        }
        private bool _waitForPostbackInvalid;

        public ValidatorCalloutScenario(ValidatorCalloutBehavior behavior, HtmlInputElement textBox, string invalidText, string validText, HtmlElement button, bool waitForPostbackInvalid, bool waitForPostbackValid)
        {
            _behavior = behavior;
            _textBox = textBox;
            _invalidText = invalidText;
            _validText = validText;
            _button = button;
            _waitForPostbackInvalid = waitForPostbackInvalid;
            _waitForPostbackValid = waitForPostbackValid;
        }
    }
}
