// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ValidatorCallout
{
    /// <summary>
    /// Common ValidatorCallout tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.ValidatorCalloutBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("ValidatorCallout")]
    public abstract class ValidatorCallout_Common
    {
        public abstract IEnumerable<ValidatorCalloutScenario> ValidatorCalloutScenarios
        {
            get;
        }

        [WebTestMethod]
        public void Common_ValidText()
        {
            foreach (ValidatorCalloutScenario validatorCalloutScenario in ValidatorCalloutScenarios)
            {
                Assert.IsFalse(validatorCalloutScenario.Behavior.IsOpen.Value);
                validatorCalloutScenario.TextBox.SetText(validatorCalloutScenario.ValidText);
                validatorCalloutScenario.Button.Click(validatorCalloutScenario.WaitForPostbackValid);
                validatorCalloutScenario.Behavior.IsOpen.Invalidate();
                Assert.IsFalse(validatorCalloutScenario.Behavior.IsOpen.Value);
            }
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_InvalidText()
        {
            foreach (ValidatorCalloutScenario validatorCalloutScenario in ValidatorCalloutScenarios)
            {
                Assert.IsFalse(validatorCalloutScenario.Behavior.IsOpen.Value);
                validatorCalloutScenario.TextBox.SetText(validatorCalloutScenario.InvalidText);
                validatorCalloutScenario.Button.Click(validatorCalloutScenario.WaitForPostbackInvalid);
                validatorCalloutScenario.Behavior.IsOpen.Invalidate();
                Assert.IsTrue(validatorCalloutScenario.Behavior.IsOpen.Value);
                validatorCalloutScenario.TextBox.SetText(validatorCalloutScenario.ValidText);
                validatorCalloutScenario.Button.Click(validatorCalloutScenario.WaitForPostbackValid);
                validatorCalloutScenario.Behavior.IsOpen.Invalidate();
                Assert.IsFalse(validatorCalloutScenario.Behavior.IsOpen.Value);
            }
        }
    }
}
