// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.UpdatePanelAnimation;

/// <summary>
/// Basic UpdatePanelAnimation tests
/// </summary>
/// <TestSuite>
///   <Path>UpdatePanelAnimation\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.UpdatePanelAnimationBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.UpdatePanelAnimation.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("UpdatePanelAnimation.Simple")]
public class UpdatePanelAnimation_Simple : UpdatePanelAnimation_Common
{
    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void Play()
    {
        SimplePage page = new SimplePage();

        page.Animations.OnUpdating.Ended.Register();
        page.Button.Click();
        page.Animations.OnUpdating.Ended.Wait(1);
        Assert.AreEqual("True", page.UpdatingResult.GetAttributes().InnerText);

        page.Animations.OnUpdated.Ended.Register();
        page.Animations.OnUpdating.Ended.Wait(1, false);
        Assert.AreEqual("True", page.UpdatedResult.GetAttributes().InnerText);
    }
}