// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ToggleButton;

/// <summary>
/// Basic MouseOver Tests
/// </summary>
/// <TestSuite>
///   <Path>ToggleButton\MouseOver.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ToggleButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ToggleButton.MouseOverPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ToggleButton.MouseOver")]
public class ToggleButton_MouseOver : ToggleButton_Common
{
    /// <summary>
    /// ToggleButtons used by the page.
    /// </summary>
    public override IEnumerable<ToggleButtonBehavior> ToggleButtons
    {
        get
        {
            MouseOverPage page = new MouseOverPage();
            yield return page.ToggleButtonExtender1;
            yield return page.ToggleButtonExtender2;
            yield return page.ToggleButtonExtender3;
            yield return page.ToggleButtonExtender4;
        }
    }
}