// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.TabPanel Model
    /// </summary>
    // <TestComponent Name="TabPanel">
    //   <ToolkitType>AjaxControlToolkit.TabPanel</ToolkitType>
    // </TestComponent>
    public class TabPanelBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// Enabled
        /// </summary>
        public BehaviorProperty<bool> Enabled
        {
            get { return _enabled; }
        }
        private BehaviorProperty<bool> _enabled;

        /// <summary>
        /// ScrollBars
        /// </summary>
        public BehaviorProperty<ScrollBars> ScrollBars
        {
            get { return _scrollBars; }
        }
        private BehaviorProperty<ScrollBars> _scrollBars;

        /// <summary>
        /// DynamicServicePath
        /// </summary>
        public BehaviorProperty<string> DynamicServicePath
        {
            get { return _dynamicServicePath; }
        }
        private BehaviorProperty<string> _dynamicServicePath;

        /// <summary>
        /// DynamicServiceMethod
        /// </summary>
        public BehaviorProperty<string> DynamicServiceMethod
        {
            get { return _dynamicServiceMethod; }
        }
        private BehaviorProperty<string> _dynamicServiceMethod;

        /// <summary>
        /// DynamicContextKey
        /// </summary>
        public BehaviorProperty<string> DynamicContextKey
        {
            get { return _dynamicContextKey; }
        }
        private BehaviorProperty<string> _dynamicContextKey;

        /// <summary>
        /// HeaderText
        /// </summary>
        public BehaviorProperty<string> HeaderText
        {
            get { return _headerText; }
        }
        private BehaviorProperty<string> _headerText;

        /// <summary>
        /// HeaderTab
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> HeaderTab
        {
            get { return _headerTab; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _headerTab;

        /// <summary>
        /// Tab
        /// </summary>
        public ReferenceBehaviorProperty<HtmlElement> Tab
        {
            get { return _tab; }
        }
        private ReferenceBehaviorProperty<HtmlElement> _tab;

        /// <summary>
        /// TabIndex
        /// </summary>
        public BehaviorProperty<int> TabIndex
        {
            get { return _tabIndex; }
        }
        private BehaviorProperty<int> _tabIndex;

        /// <summary>
        /// Active
        /// </summary>
        public BehaviorProperty<bool> Active
        {
            get { return _active; }
        }
        private BehaviorProperty<bool> _active;

        /// <summary>
        /// Click
        /// </summary>
        public BehaviorEvent Click
        {
            get { return _click; }
        }
        private BehaviorEvent _click;

        /// <summary>
        /// Populating
        /// </summary>
        public BehaviorEvent Populating
        {
            get { return _populating; }
        }
        private BehaviorEvent _populating;

        /// <summary>
        /// Populated
        /// </summary>
        public BehaviorEvent Populated
        {
            get { return _populated; }
        }
        private BehaviorEvent _populated;

        /// <summary>
        /// AjaxControlToolkit.TabPanel Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public TabPanelBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _enabled = BehaviorProperty<bool>.CreateProperty(this, "enabled");
            _scrollBars = BehaviorProperty<ScrollBars>.CreateProperty(this, "scrollBars");
            _dynamicServicePath = BehaviorProperty<string>.CreateProperty(this, "dynamicServicePath");
            _dynamicServiceMethod = BehaviorProperty<string>.CreateProperty(this, "dynamicServiceMethod");
            _dynamicContextKey = BehaviorProperty<string>.CreateProperty(this, "dynamicContextKey");
            _headerText = BehaviorProperty<string>.CreateProperty(this, "headerText");
            _headerTab = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}.get_headerTab()", null, "throw 'HeaderTab property is read-only!'");
            _tab = ReferenceBehaviorProperty<HtmlElement>.CreateField(this, "id", "{0}._tab", null, "throw 'Tab property is read-only!'");
            _tabIndex = BehaviorProperty<int>.CreateProperty(this, "tabIndex", null, null, "throw 'TabIndex property is read-only!'");
            _active = BehaviorProperty<bool>.CreateCustomProperty(this, null, "{0}._get_active()", "{0}._set_active({1})");
            _click = BehaviorEvent<object>.CreateEvent(this, "click");
            _populating = BehaviorEvent<object>.CreateEvent(this, "populating");
            _populated = BehaviorEvent<object>.CreateEvent(this, "populated");
        }
    }
}