// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit;

namespace AjaxControlToolkit.Testing.Client
{
    /// <summary>
    /// AjaxControlToolkit.ResizableControlExtender Model
    /// </summary>
    /// <TestComponent Name="ResizableControl">
    ///   <ToolkitType>AjaxControlToolkit.ResizableControlExtender</ToolkitType>
    ///   <CommonTestSuite>AjaxControlToolkit.Testing.Client.ResizableControl.ResizableControl_Common</CommonTestSuite>
    /// </TestComponent>
    public class ResizableControlBehavior : Behavior<HtmlElement>
    {
        /// <summary>
        /// HandleCssClass
        /// </summary>
        public BehaviorProperty<string> HandleCssClass
        {
            get { return _handleCssClass; }
        }
        private BehaviorProperty<string> _handleCssClass;

        /// <summary>
        /// ResizableCssClass
        /// </summary>
        public BehaviorProperty<string> ResizableCssClass
        {
            get { return _resizableCssClass; }
        }
        private BehaviorProperty<string> _resizableCssClass;

        /// <summary>
        /// HandleOffsetX
        /// </summary>
        public BehaviorProperty<int> HandleOffsetX
        {
            get { return _handleOffsetX; }
        }
        private BehaviorProperty<int> _handleOffsetX;

        /// <summary>
        /// HandleOffsetY
        /// </summary>
        public BehaviorProperty<int> HandleOffsetY
        {
            get { return _handleOffsetY; }
        }
        private BehaviorProperty<int> _handleOffsetY;

        /// <summary>
        /// MinimumWidth
        /// </summary>
        public BehaviorProperty<int> MinimumWidth
        {
            get { return _minimumWidth; }
        }
        private BehaviorProperty<int> _minimumWidth;

        /// <summary>
        /// MinimumHeight
        /// </summary>
        public BehaviorProperty<int> MinimumHeight
        {
            get { return _minimumHeight; }
        }
        private BehaviorProperty<int> _minimumHeight;

        /// <summary>
        /// MaximumWidth
        /// </summary>
        public BehaviorProperty<int> MaximumWidth
        {
            get { return _maximumWidth; }
        }
        private BehaviorProperty<int> _maximumWidth;

        /// <summary>
        /// MaximumHeight
        /// </summary>
        public BehaviorProperty<int> MaximumHeight
        {
            get { return _maximumHeight; }
        }
        private BehaviorProperty<int> _maximumHeight;

        /// <summary>
        /// OnClientResize
        /// </summary>
        public BehaviorProperty<string> OnClientResize
        {
            get { return _onClientResize; }
        }
        private BehaviorProperty<string> _onClientResize;

        /// <summary>
        /// OnClientResizing
        /// </summary>
        public BehaviorProperty<string> OnClientResizing
        {
            get { return _onClientResizing; }
        }
        private BehaviorProperty<string> _onClientResizing;

        /// <summary>
        /// OnClientResizeBegin
        /// </summary>
        public BehaviorProperty<string> OnClientResizeBegin
        {
            get { return _onClientResizeBegin; }
        }
        private BehaviorProperty<string> _onClientResizeBegin;

        /// <summary>
        /// Size
        /// </summary>
        public BehaviorProperty<Size> Size
        {
            get { return _size; }
        }
        private BehaviorProperty<Size> _size;

        /// <summary>
        /// Resize
        /// </summary>
        public BehaviorEvent ResizeBegin
        {
            get { return _resizeBegin; }
        }
        private BehaviorEvent _resizeBegin;

        /// <summary>
        /// Resize
        /// </summary>
        public BehaviorEvent Resizing
        {
            get { return _resizing; }
        }
        private BehaviorEvent _resizing;

        /// <summary>
        /// Resize
        /// </summary>
        public BehaviorEvent Resize
        {
            get { return _resize; }
        }
        private BehaviorEvent _resize;

        /// <summary>
        /// AjaxControlToolkit.ResizableControlExtender Model
        /// </summary>
        /// <param name="element">Target element</param>
        /// <param name="behaviorID">Behavior ID</param>
        /// <param name="page">Page Model</param>
        public ResizableControlBehavior(HtmlElement element, string behaviorID, ToolkitTestPage page)
            : base(element, behaviorID, page)
        {
            _handleCssClass = BehaviorProperty<string>.CreateProperty(this, "HandleCssClass");
            _resizableCssClass = BehaviorProperty<string>.CreateProperty(this, "ResizableCssClass");
            _handleOffsetX = BehaviorProperty<int>.CreateProperty(this, "HandleOffsetX");
            _handleOffsetY = BehaviorProperty<int>.CreateProperty(this, "HandleOffsetY");
            _minimumWidth = BehaviorProperty<int>.CreateProperty(this, "MinimumWidth");
            _minimumHeight = BehaviorProperty<int>.CreateProperty(this, "MinimumHeight");
            _maximumWidth = BehaviorProperty<int>.CreateProperty(this, "MaximumWidth");
            _maximumHeight = BehaviorProperty<int>.CreateProperty(this, "MaximumHeight");
            _onClientResize = BehaviorProperty<string>.CreateProperty(this, "resize");
            _onClientResizing = BehaviorProperty<string>.CreateProperty(this, "resizing");
            _onClientResizeBegin = BehaviorProperty<string>.CreateProperty(this, "resizebegin");

            _size = BehaviorProperty<Size>.CreateProperty(this, "Size", ConvertSize);
            _resizeBegin = BehaviorEvent<object>.CreateEvent(this, "resizebegin");
            _resizing = BehaviorEvent<object>.CreateEvent(this, "resizing");
            _resize = BehaviorEvent<object>.CreateEvent(this, "resize");
        }

        private static Size ConvertSize(object value)
        {
            return (null == value) ? System.Drawing.Size.Empty : new Size(Common.GetJson<int>(value, "width"), Common.GetJson<int>(value, "height"));
        }

        /// <summary>
        /// Set the size as the user would
        /// </summary>
        /// <param name="size">new size to set</param>
        public void SetSize(Size size)
        {
            Page.ExecuteScript(
                "var b = $find('" + BehaviorID + "');" +
                "b._onmousedownImplementation(0, 0);" +
                "b.set_Size( { width:" + size.Width + ", height:" + size.Height + " } );" +
                "b._onmouseup();");
            _size.Invalidate();
        }
    }
}
