// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.ModalPopup
{
    /// <summary>
    /// Common ModalPopup tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.ModalPopupBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("ModalPopup")]
    public abstract class ModalPopup_Common
    {
        public abstract IEnumerable<ModalPopupBehavior> ModalPopups
        {
            get;
        }

        [WebTestMethod]
        public void Common_CloseModalPopupWithOkButton()
        {
            foreach (ModalPopupBehavior modalPopup in ModalPopups)
            {
                if (modalPopup.OkControl.Reference != null)
                {
                    modalPopup.ShowPopup();
                    modalPopup.ClickOK();
                }
            }
        }

        [WebTestMethod]
        public void Common_CloseModalPopupWithCancelButton()
        {
            foreach (ModalPopupBehavior modalPopup in ModalPopups)
            {
                if (modalPopup.CancelControl.Reference != null)
                {
                    modalPopup.ShowPopup();
                    modalPopup.ClickCancel();
                }
            }
        }

        [WebTestMethod]
        public void Common_DisabledShowButton()
        {
            foreach (ModalPopupBehavior modalPopup in ModalPopups)
            {
                if (0 == string.Compare(modalPopup.Element.TagName, "INPUT", StringComparison.OrdinalIgnoreCase))
                {
                    modalPopup.Page.ExecuteScript(string.Format("$get('{0}').disabled = true", modalPopup.Element.Id));
                    modalPopup.Element.Click();
                    Assert.IsTrue(modalPopup.IsHidden);
                }
            }
        }

        [WebTestMethod]
        [WebTestFailureTag(Browsers.Firefox | Browsers.Opera | Browsers.Safari, "Disabled anchor tags still cause postbacks.")]
        public void Common_DisabledShowLink()
        {
            foreach (ModalPopupBehavior modalPopup in ModalPopups)
            {
                if (0 == string.Compare(modalPopup.Element.TagName, "A", StringComparison.OrdinalIgnoreCase))
                {
                    modalPopup.Page.ExecuteScript(string.Format("$get('{0}').disabled = true", modalPopup.Element.Id));
                    modalPopup.Element.Click();
                    Assert.IsTrue(modalPopup.IsHidden);
                }
            }
        }

        [WebTestMethod]
        public void Common_BackgroundDivStyle()
        {
            foreach (ModalPopupBehavior modalPopup in ModalPopups)
            {
                if (String.IsNullOrEmpty(modalPopup.BackgroundCssClass.Value) == false)
                {
                    Assert.AreEqual(modalPopup.BackgroundCssClass.Value, modalPopup.BackgroundDiv.Reference.GetAttributes().Class);
                }
            }
        }

    }
}