// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ListSearch;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ListSearch\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ListSearchBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ListSearch.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ListSearch.Sample")]
[WebTestTag("SampleWebSite")]
public class ListSearch_Sample : ListSearch_Common
{
    public override IEnumerable<ListSearchBehavior> ListSearchBehaviors
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.ListSearchExtender1;
            yield return page.ListSearchExtender2;
        }
    }
}
