// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.HoverMenu;

/// <summary>
/// Make sure that text in the menu panel is set to the return value of the webservice
/// </summary>
/// <TestSuite>
///   <Path>HoverMenu\DynamicPopulate.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.HoverMenuBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.HoverMenu.DynamicPopulatePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("HoverMenu.DynamicPopulate")]
public class HoverMenu_DynamicPopulate : AjaxControlToolkit.Testing.Client.HoverMenu.HoverMenu_Common
{
    public override IEnumerable<HoverMenuBehavior> HoverMenus
    {
        get 
        {
            yield return new DynamicPopulatePage().HoverMenuExtender1;
        }
    }

    /// <summary>
    /// Make sure that the dynamic context returned by the webservice
    /// is set correctly in the menu markup.
    /// </summary>
    [WebTestMethod]
    public void ValidateDynamicContext()
    {
        DynamicPopulatePage page = new DynamicPopulatePage();
        HoverMenuBehavior hoverMenu = page.HoverMenuExtender1;

        hoverMenu.AssertHover();
        string innerText = hoverMenu.PopupControl.Reference.GetAttributes().InnerText.Trim();
        Assert.AreEqual(hoverMenu.DynamicContextKey.Value, innerText);
        hoverMenu.AssertUnHover();
        

    }


    /// <summary>
    /// Attempt changing the context key and make sure that the right
    /// one is returned by the webservice and set in the innerText.
    /// </summary>
    [WebTestMethod]
    public void ChangeDynamicContext()
    {
        DynamicPopulatePage page = new DynamicPopulatePage();
        HoverMenuBehavior hoverMenu = page.HoverMenuExtender1;

        string newContextKey = "FooBar";
        hoverMenu.DynamicContextKey.Value = newContextKey;
        Assert.AreEqual(newContextKey, hoverMenu.DynamicContextKey.Value);
        hoverMenu.AssertHover();
        string innerText = hoverMenu.PopupControl.Reference.GetAttributes().InnerText.Trim();
        Assert.AreEqual(newContextKey, innerText);
    }

}
