// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ExtenderBase;

/// <summary>
/// CSS via WebResource in Markup
/// </summary>
/// <TestSuite>
///   <Path>ExtenderBase\CssWebResourceMarkup.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ExtenderBaseBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ExtenderBase.CssWebResourceMarkupPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ExtenderBase.CssWebResourceMarkup")]
public class ExtenderBase_CssWebResourceMarkup : AjaxControlToolkit.Testing.Client.ExtenderBase.ExtenderBase_Common
{
    [WebTestMethod]
    public void CssLoaded()
    {
        CssWebResourceMarkupPage page = new CssWebResourceMarkupPage();

        // Check Calendar CSS (ExtenderControlBase)
        Assert.AreEqual("20px", Common.GetCurrentStyle<string>(page.Label, "height"));
        // Check TabContainer CSS (ScriptControlBase)
        Assert.AreEqual("4px", Common.GetCurrentStyle<string>(page.Label, "marginRight"));
    }
}
