// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DropShadow;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>DropShadow\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropShadowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DropShadow.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DropShadow.Sample")]
[WebTestTag("SampleWebSite")]
public class DropShadow_Sample : AjaxControlToolkit.Testing.Client.DropShadow.DropShadow_Common
{
    public override IEnumerable<DropShadowBehavior> DropShadows
    {
        get
        {
            yield return new SamplePage().DropShadowExtender1;
        }
    }
}