
// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.CollapsiblePanel
{
    /// <summary>
    /// Common CollapsiblePanel tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.CollapsiblePanelBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("CollapsiblePanel")]
    public abstract class CollapsiblePanel_Common
    {
        public abstract IEnumerable<CollapsiblePanelBehavior> CollapsiblePanels
        {
            get;
        }

        public abstract bool SupportsPostback
        {
            get;
        }

        public abstract void DoPostback(CollapsiblePanelBehavior collapsiblePanel);

        [WebTestMethod]
        public void Common_Initial()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                if (collapsiblePanel.Collapsed.Value)
                {
                    collapsiblePanel.AssertCollapsed();
                }
                else
                {
                    collapsiblePanel.AssertExpanded();
                }
            }
        }

        [WebTestMethod]
        public void Common_Collapse()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                collapsiblePanel.AssertAndExpand();
                collapsiblePanel.Collapse();
            }
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_Expand()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                collapsiblePanel.AssertAndCollapse();
                collapsiblePanel.Expand();
            }
        }

        [WebTestMethod]
        public void Common_CollapseAgain()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                collapsiblePanel.AssertAndExpand();
                collapsiblePanel.Collapse();
                collapsiblePanel.Expand();
                collapsiblePanel.Collapse();
            }
        }

        [WebTestMethod]
        public void Common_CollapsePreservedOnPostback()
        {
            if (SupportsPostback)
            {
                foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
                {
                    collapsiblePanel.AssertAndExpand();
                    collapsiblePanel.Collapse();
                    DoPostback(collapsiblePanel);
                    collapsiblePanel.AssertCollapsed();
                }
            }
        }

        [WebTestMethod]
        public void Common_ExpandPreservedOnPostback()
        {
            if (SupportsPostback)
            {
                foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
                {
                    collapsiblePanel.AssertAndCollapse();
                    collapsiblePanel.Expand();
                    DoPostback(collapsiblePanel);
                    collapsiblePanel.AssertExpanded();
                }
            }
        }

        [WebTestMethod]
        public void Common_BehaviorCollapse()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                collapsiblePanel.AssertAndExpand();
                collapsiblePanel.BehaviorCollapse();
            }
        }

        [WebTestMethod]
        public void Common_BehaviorExpand()
        {
            foreach (CollapsiblePanelBehavior collapsiblePanel in CollapsiblePanels)
            {
                collapsiblePanel.AssertAndCollapse();
                collapsiblePanel.BehaviorExpand();
            }
        }
    }
}