// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Test the webservice returns the right values and the flyout is
/// initialized with the same and selecting some results in the right value in
/// the textbox. 
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\Options.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.OptionsPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.Options")]
public class AutoComplete_Options : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get
        {
            yield return (new OptionsPage().AutoCompleteExtender1);
        }
    }
    

    /// <summary>
    /// Make sure that the number of suggestions in the AutoComplete textbox
    /// are equal to the property set on the behavior.
    /// </summary>
    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void AutoCompleteOptions()
    {
        string testString = "1234";
        OptionsPage page = new OptionsPage();
        AutoCompleteBehavior autocomplete = page.AutoCompleteExtender1;
        autocomplete.SetTextWaitForFlyout(testString);
        int numberOfSuggestions = autocomplete.ActualCompletionSetCount;
        for (int i = 0; i < numberOfSuggestions; ++i)
        {
            // make sure the suggestions start with the prefix
            Assert.IsTrue(autocomplete.GetOption(i).StartsWith(testString));
            Assert.IsTrue(autocomplete.GetOption(i).Length == testString.Length + 1);
        }
        autocomplete.ChooseOption(5);
        Assert.AreEqual(testString + "5", page.AutoCompleteExtender1.TextBoxValue);
    }
}