using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Test class for testing ShowOnlyCurrentWordInCompletionListItem property of AutoCompleteExtender
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\OnlyCurrentWordSuggestionsInList.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.OfferOnlyCurrentWordPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.OfferOnlyCurrentWord")]
public class AutoComplete_OfferOnlyCurrentWord : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
	public override IEnumerable<AutoCompleteBehavior> AutoCompletes
	{
		get
		{
			yield return new OfferOnlyCurrentWordPage().Behavior;
		}
	}

	/// <summary>
	/// Tests whether for first entered word it suggests options starting with first word
	/// and for second entered word it suggests options starting with second word
	/// </summary>
	[WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void OnlyCurrentWordSuggestionsInList()
	{
		//Two words
		String sWord1 = "preved";
		String sWord2 = "medved";
		String sWholeSentence = "The,AJAX,Control,Toolkit,is,a,joint,project,between,the,community,and,Microsoft,";
		//Our page
		OfferOnlyCurrentWordPage page = new OfferOnlyCurrentWordPage();

		//Setting 1st word
		page.Behavior.SetTextWaitForFlyout(sWord1);		
		//Checking whether options start with first word
		Assert.IsTrue(page.Behavior.GetOption(0).StartsWith(sWord1));

		//Setting sentence {sWord1},{sWord2}
		page.Behavior.SetTextWaitForFlyout(sWord1 + "," + sWord2);
		//Checking whether options start with second word
		Assert.IsTrue(page.Behavior.GetOption(0).StartsWith(sWord2));

		//Setting sentence {sWholeSentence},{sWord1}
		page.Behavior.SetTextWaitForFlyout(sWholeSentence + "," + sWord1);
		//Checking whether options start with first word
		Assert.IsTrue(page.Behavior.GetOption(0).StartsWith(sWord1));
	}
}