package com.apptl.chapter2.threads;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.SystemClock;
import android.view.View;
import android.widget.ProgressBar;
import com.apptl.chapter2.R;

/**
 * @author Erik Hellman
 */
public class MyAsyncTask extends AsyncTask<String, Integer, Integer> {
    private Activity mActivity;

    public MyAsyncTask(Activity activity) {
        mActivity = activity;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        // To bdzie dziaa w wtku gwnym
        mActivity.findViewById(R.id.progressBar).
                setVisibility(View.VISIBLE);
        ((ProgressBar) mActivity.findViewById(R.id.progressBar)).
                setProgress(0);
    }

    @Override
    protected Integer doInBackground(String... inputs) {
        // To NIE bdzie dziaa w wtku gwnym
        int progress = 0;

        for (String input : inputs) {
           // Wysanie danych do serwera (imitacja poprzez upienie)
            SystemClock.sleep(50);
            publishProgress(++progress, inputs.length);
        }
        return progress;
    }

    @Override
    protected void onProgressUpdate(Integer... values) {
        // To bdzie dziaa w wtku gwnym
        ((ProgressBar) mActivity.findViewById(R.id.progressBar)).
                setMax(values[1]);
        ((ProgressBar) mActivity.findViewById(R.id.progressBar)).
                setProgress(values[0]);
    }

    @Override
    protected void onPostExecute(Integer i) {
        super.onPostExecute(i);
        // To bdzie dziaa w wtku gwnym
        mActivity.findViewById(R.id.progressBar).
                setVisibility(View.INVISIBLE);
    }
}
