USE AdventureWorks 
GO

SELECT COUNT(SalesOrderID)
FROM Sales.SalesOrderHeader;

SELECT COUNT(CustomerID)
FROM Sales.SalesOrderHeader;

SELECT COUNT(DISTINCT CustomerID)
FROM Sales.SalesOrderHeader;

SELECT DISTINCT COUNT(CustomerID)
FROM Sales.SalesOrderHeader;

SELECT COUNT(*)
FROM Sales.SalesOrderHeader;

SELECT COUNT(DISTINCT *)
FROM Sales.SalesOrderHeader;

SELECT SUM(TotalDue), AVG(TotalDue)
FROM Sales.SalesOrderHeader;
GO

CREATE TABLE #Tab
(id INT IDENTITY,
val INT);
GO
INSERT INTO #TAB (val)
VALUES
(2),(4);
GO

SELECT * 
FROM #TAB;

SELECT SUM(val), AVG(val) 
FROM #TAB;

INSERT INTO #TAB(val)
VALUES (NULL);
SELECT AVG(val), COUNT(*), COUNT(val)
FROM #TAB;

SELECT SUM(ListPrice), SUM(DISTINCT ListPrice)
FROM Production.Product;

SELECT MIN(SellStartDate), MAX(SellStartDate)
FROM Production.Product;

SELECT MIN(Name), MAX(Name)
FROM Production.Product;

SELECT MIN(ProductID), MAX(ProductID), COUNT(*), MAX(ProductID)-MIN(ProductID)-COUNT(*)
FROM Production.Product;

SELECT CHECKSUM_AGG(CAST(ListPrice AS INT))
FROM Production.Product;

SELECT STDEV(ListPrice)
FROM Production.Product;

SELECT STDEVP(ListPrice)
FROM Production.Product;

SELECT VAR(ListPrice)
FROM Production.Product;

SELECT VARP(ListPrice)
FROM Production.Product;

SELECT MAX(ListPrice) - MIN(ListPrice),MAX(ListPrice) - AVG(ListPrice)
FROM Production.Product;

SELECT AVG(ListPrice*1.22)
FROM Production.Product;

SELECT AVG(ListPrice)*1.22
FROM Production.Product;

SELECT MAX(AVG(ListPrice))
FROM Production.Product;

SELECT AVG(ListPrice)
FROM Production.Product
GROUP BY ProductSubcategoryID;

SELECT ProductSubcategoryID, AVG(ListPrice)
FROM Production.Product
GROUP BY ProductSubcategoryID;

SELECT SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY P.ProductSubcategoryID;

SELECT SC.Name, AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY SC.Name;

SELECT LEFT(SC.Name,1),AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY LEFT(SC.Name,1);

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY SC.ProductCategoryID,SC.Name;

SELECT COUNT(SalesOrderID)
FROM Sales.SalesOrderHeader;

SELECT COUNT(SalesOrderID)
FROM Sales.SalesOrderHeader
GROUP BY ();

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE AVG(P.ListPrice)>1000
GROUP BY SC.ProductCategoryID,SC.Name;

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE SC.Name LIKE 'B%'
GROUP BY SC.ProductCategoryID,SC.Name;

SELECT MONTH(OrderDate), CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY MONTH(OrderDate), CustomerID
ORDER BY OrderDate; 

SELECT SC.ProductCategoryID,SC.Name,SUM(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE SC.Name LIKE 'B%'
GROUP BY ROLLUP (SC.ProductCategoryID,SC.Name);

SELECT OrderDate, CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY OrderDate, CustomerID;

SELECT OrderDate, CustomerID, SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2003
GROUP BY CUBE (OrderDate, CustomerID);

SELECT SC.ProductCategoryID,GROUPING(SC.ProductCategoryID),SC.Name,GROUPING(SC.Name),SUM(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE SC.Name LIKE 'B%'
GROUP BY ROLLUP(SC.ProductCategoryID,SC.Name);

SELECT GROUPING_ID(SC.ProductCategoryID,SC.Name)AS Poziom, SC.ProductCategoryID,SC.Name, SUM(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE SC.Name LIKE 'B%'
GROUP BY ROLLUP(SC.ProductCategoryID,SC.Name);

SELECT MONTH(OrderDate),TerritoryID ,CustomerID,SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2004
GROUP BY MONTH(OrderDate),TerritoryID,CustomerID
UNION ALL
SELECT MONTH(OrderDate),TerritoryID,NULL,SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2004
GROUP BY MONTH(OrderDate),TerritoryID
UNION ALL
SELECT MONTH(OrderDate),NULL,CustomerID,SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2004
GROUP BY MONTH(OrderDate),CustomerID;

SELECT MONTH(OrderDate),TerritoryID ,CustomerID,SUM(TotalDue)
FROM Sales.SalesOrderHeader
WHERE SalesPersonID=288 AND YEAR(OrderDate)=2004
GROUP BY GROUPING SETS (
(MONTH(OrderDate), TerritoryID,CustomerID),
(MONTH(OrderDate), TerritoryID),
(MONTH(OrderDate), CustomerID) );

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY SC.ProductCategoryID,SC.Name;

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY GROUPING SETS (
(SC.ProductCategoryID,SC.Name));

SELECT SalesOrderID, TotalDue
FROM Sales.SalesOrderHeader
WHERE CustomerID =288;

SELECT SalesOrderID, TotalDue, AVG(TotalDue)
FROM Sales.SalesOrderHeader
WHERE CustomerID =288;

SELECT SalesOrderID, TotalDue, AVG(TotalDue)
FROM Sales.SalesOrderHeader
WHERE CustomerID =288
GROUP BY SalesOrderID, TotalDue;

SELECT SalesOrderID, TotalDue, AVG(TotalDue) OVER() 
FROM Sales.SalesOrderHeader
WHERE CustomerID =288;

SELECT SalesOrderID, TotalDue, 
MIN(TotalDue) OVER() AS Minimum,
MAX(TotalDue) OVER() AS Maksimum,
AVG(TotalDue) OVER() AS rednia,
TotalDue - AVG(TotalDue) OVER() AS Rnica
FROM Sales.SalesOrderHeader
WHERE CustomerID =288;

SELECT ProductCategoryID
FROM Production.ProductSubcategory;

SELECT ProductCategoryID, COUNT(*)
OVER (PARTITION BY ProductCategoryID) AS LiczbaDuplikatw
FROM Production.ProductSubcategory
ORDER BY LiczbaDuplikatw;

SELECT DISTINCT ProductCategoryID, COUNT(*)
OVER (PARTITION BY ProductCategoryID) AS LiczbaDuplikatw
FROM Production.ProductSubcategory
ORDER BY LiczbaDuplikatw;

SELECT DISTINCT ProductSubcategoryID,ProductModelID, COUNT(*)
OVER (PARTITION BY ProductSubcategoryID, ProductModelID) 
FROM Production.Product;

SELECT FirstName, 
ROW_NUMBER() OVER(ORDER BY FirstName),
RANK() OVER(ORDER BY FirstName),
DENSE_RANK() OVER(ORDER BY FirstName),
NTILE(3) OVER (ORDER BY FirstName) 
FROM Person.Contact
WHERE FirstName IN ('Tai','Juanita');

SELECT FirstName, Title, 
ROW_NUMBER() OVER (PARTITION BY Title ORDER BY FirstName)
FROM Person.Contact
WHERE ContactID <10
ORDER BY Title;

SELECT OD.ProductID, YEAR(H.OrderDate) AS Rok, SUM(OD.LineTotal) AS Sprzeda
FROM Sales.SalesOrderDetail OD JOIN Sales.SalesOrderHeader H 
ON OD.SalesOrderID = H. SalesOrderID
WHERE OD.ProductID IN (723,945,949)
GROUP BY OD.ProductID, YEAR(H.orderdate)
ORDER BY OD.ProductID, YEAR(H.orderdate);

SELECT OD.ProductID, YEAR(H.OrderDate) AS Rok, SUM(OD.LineTotal) AS Sprzeda
INTO #TabPivot
FROM Sales.SalesOrderDetail OD JOIN Sales.SalesOrderHeader H 
ON OD.SalesOrderID = H. SalesOrderID
WHERE OD.ProductID IN (723,945,949)
GROUP BY OD.ProductID, YEAR(H.orderdate);

SELECT P.ProductID, [2001], [2002],[2003], [2004]
FROM #TabPivot
PIVOT ( 
SUM(Sprzeda)
FOR Rok IN ([2001], [2002], [2003], [2004]) ) AS P
ORDER BY P.ProductID;

SELECT P.ProductID, [2001], [2002],[2003], [2004]
INTO #TabUnpivot
FROM #TabPivot
PIVOT ( 
SUM(Sprzeda)
FOR Rok IN ([2001], [2002], [2003], [2004]) ) AS P
ORDER BY P.ProductID;

SELECT Unpiv.ProductID, Unpiv.Rok, Unpiv.Sprzeda
FROM #TabUnpivot
UNPIVOT (Sprzeda FOR Rok IN ([2001], [2002], [2003], [2004])) AS Unpiv;

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
WHERE AVG(P.ListPrice)>1000
GROUP BY SC.ProductCategoryID,SC.Name;

SELECT SC.ProductCategoryID,SC.Name,AVG(P.ListPrice)
FROM Production.Product AS P JOIN Production.ProductSubcategory AS SC
ON P.ProductSubcategoryID=SC.ProductSubcategoryID
GROUP BY SC.ProductCategoryID,SC.Name
HAVING AVG(P.ListPrice)>1000;

SELECT Title, AVG(VacationHours)
FROM HumanResources.Employee
GROUP BY Title
HAVING VacationHours>90;

SELECT Title, AVG(VacationHours)
FROM HumanResources.Employee
WHERE VacationHours>90
GROUP BY Title;

SELECT Title, AVG(VacationHours)
FROM HumanResources.Employee
GROUP BY Title
HAVING AVG(VacationHours)>90;

SELECT EndDate, ListPrice, COUNT(ProductID)
FROM Production.ProductListPriceHistory
WHERE ProductID < 710
GROUP BY EndDate, ListPrice
HAVING EndDate IS NOT NULL;

SELECT EndDate, ListPrice, COUNT(ProductID)
FROM Production.ProductListPriceHistory
WHERE ProductID < 710
GROUP BY EndDate, ListPrice
HAVING EndDate IS NOT NULL AND COUNT(ProductID) > 1;
GO

CREATE TABLE #MiesiecznaSprzedaz 
(CustomerID int NOT NULL, 
OrderMonth int NOT NULL,
SubTotal money NOT NULL);
GO
INSERT #MiesiecznaSprzedaz 
SELECT CustomerID, DATEPART(m, OrderDate), 
SubTotal FROM Sales.SalesOrderHeader 
WHERE CustomerID <5;
