USE Northwind
GO

SELECT [Kod produktu],[Nazwa produktu], [Cena katalogowa]
FROM dbo.Produkty
WHERE Wycofane=0;
GO

CREATE VIEW dbo.vAktualnaOferta AS
SELECT [Kod produktu],[Nazwa produktu], [Cena katalogowa]
FROM dbo.Produkty
WHERE Wycofane=0;
GO

SELECT TOP 4 *
FROM dbo.vAktualnaOferta 
ORDER BY  [Cena katalogowa] DESC;
GO

CREATE VIEW dbo.vPracownicy AS 
SELECT TOP 100 PERCENT P.Nazwisko, P.Imi, P.Uwagi, U.[Nazwa uprawnienia] 
FROM dbo.Pracownicy AS P LEFT JOIN dbo.[Uprawnienia pracownika] AS UP
ON P.ID=UP.[ID pracownika]
LEFT JOIN dbo.Uprawnienia AS U ON UP.[ID uprawnienia]=U.[ID uprawnienia]
ORDER BY P.Imi;
GO

SELECT Imi, Nazwisko , [Nazwa uprawnienia]
FROM dbo.vPracownicy;

SELECT Imi, Nazwisko , [Nazwa uprawnienia]
FROM dbo.vPracownicy
ORDER BY Imi;
GO

ALTER VIEW dbo.vPracownicy AS 
SELECT P.Nazwisko, P.Imi, P.Uwagi, U.[Nazwa uprawnienia], P.ID 
FROM dbo.Pracownicy AS P LEFT JOIN dbo.[Uprawnienia pracownika] AS UP
ON P.ID=UP.[ID pracownika]
LEFT JOIN dbo.Uprawnienia AS U ON UP.[ID uprawnienia]=U.[ID uprawnienia];
GO

SELECT P.Nazwisko, P.Imi, P.Uwagi, U.[Nazwa uprawnienia] 
FROM dbo.Pracownicy AS P LEFT JOIN dbo.[Uprawnienia pracownika] AS UP
ON P.ID=UP.[ID pracownika]
LEFT JOIN dbo.Uprawnienia AS U ON UP.[ID uprawnienia]=U.[ID uprawnienia]
WHERE P.Nazwisko LIKE '%a';
SELECT *
FROM dbo.vPracownicy
WHERE Nazwisko LIKE '%a';
GO

CREATE VIEW dbo.[vZamwienia pracownikw] AS
SELECT V.Imi,V.Nazwisko,V.[Nazwa uprawnienia], Z.[ID zamwienia], Z.[Data zamwienia]
FROM dbo.vPracownicy AS V
JOIN dbo.Zamwienia AS Z
ON V.ID=Z.[ID pracownika]
GO

SET SHOWPLAN_TEXT ON;
GO
SELECT * 
FROM dbo.[vZamwienia pracownikw]
WHERE [Data zamwienia] LIKE '2006-03%';
GO
SET SHOWPLAN_TEXT OFF;
GO

CREATE VIEW dbo.vDziennyObrot (Data, Klientow, Sprzedawcow, Zamowien, redniaOpat, SumaOpat) AS
SELECT [Data zamwienia], COUNT (DISTINCT [ID klienta]), COUNT (DISTINCT [ID pracownika]), COUNT([ID zamwienia]), AVG ([Opata za wysyk]), SUM([Opata za wysyk])
FROM dbo.Zamwienia
GROUP BY [Data zamwienia];
GO

SELECT *
FROM dbo.vDziennyObrot 
WHERE redniaOpat>50 AND Klientow>2;
GO

CREATE VIEW dbo.vSosy AS
SELECT ID,[Kod produktu],[Nazwa produktu],[Cena katalogowa], Kategoria
FROM dbo.Produkty
WHERE Kategoria='Sosy';
GO

INSERT INTO dbo.vSosy ([Kod produktu],[Nazwa produktu],[Cena katalogowa],Kategoria)
VALUES ('NWTC-88','Northwind Traders Chili',25,'Sosy');
SELECT *
FROM dbo.vSosy
WHERE [Kod produktu] LIKE 'NWT%'

INSERT INTO dbo.vSosy ([Kod produktu],[Nazwa produktu],[Cena katalogowa],Kategoria)
VALUES ('NWTC-66','Northwind Traders Chili',25,'Napoje');
SELECT *
FROM dbo.vSosy
WHERE [Kod produktu] LIKE 'NWT%';

SELECT *
FROM dbo.vSosy
WHERE ID=8;
UPDATE dbo.vSosy
SET Kategoria='Napoje'
WHERE ID=8;

SELECT *
FROM dbo.vSosy
WHERE ID=8;
GO

ALTER VIEW dbo.vSosy AS
SELECT ID,[Kod produktu],[Nazwa produktu],[Cena katalogowa], Kategoria
FROM dbo.Produkty
WHERE Kategoria='Sosy'
WITH CHECK OPTION;
GO

INSERT INTO dbo.vSosy ([Kod produktu],[Nazwa produktu],[Cena katalogowa],Kategoria)
VALUES ('NWTC-33','Northwind Traders Apple Juice',25,'Napoje');
GO

CREATE INDEX IX_SalesOrderDetailUnitPrice
ON AdventureWorks.Sales.SalesOrderDetail (UnitPrice);

SELECT UnitPrice,OrderQty
FROM AdventureWorks.Sales.SalesOrderDetail
WHERE UnitPrice BETWEEN 100 AND 115;

SELECT UnitPrice,OrderQty
FROM AdventureWorks.Sales.SalesOrderDetail
WHERE UnitPrice BETWEEN 100 AND 150;

DROP INDEX IX_SalesOrderDetailUnitPrice
ON AdventureWorks.Sales.SalesOrderDetail;
CREATE INDEX IX_SalesOrderDetailUnitPrice
ON AdventureWorks.Sales.SalesOrderDetail (UnitPrice,OrderQty);
GO

CREATE UNIQUE INDEX UX_ProductNameListPrice
ON AdventureWorks.Production.Product (Name,ListPrice);

ALTER INDEX ALL
ON AdventureWorks.HumanResources.Department
REBUILD;

ALTER INDEX IX_Employee_ManagerID
ON AdventureWorks.HumanResources.Employee
REORGANIZE;
