USE Northwind
GO

SELECT [ID spedytora]
FROM dbo.Zamwienia
WHERE [ID zamwienia] = 35;

SELECT Firma
FROM dbo.Spedytorzy
WHERE ID=2;

SELECT S.Firma
FROM dbo.Spedytorzy AS S
WHERE S.ID = 
	(SELECT Z.[ID spedytora]
	FROM dbo.Zamwienia AS Z
	WHERE Z.[ID zamwienia]  = 35);

SELECT AVG([Cena katalogowa]) 
FROM dbo.Produkty; 

SELECT [Nazwa produktu],[Cena katalogowa] , '15,8457'
FROM dbo.Produkty;

SELECT [Nazwa produktu],[Cena katalogowa],
	(SELECT AVG([Cena katalogowa]) 
	FROM dbo.Produkty)
FROM dbo.Produkty;

SELECT [Nazwa produktu],[Cena katalogowa],
	(SELECT AVG([Cena katalogowa]) 
	FROM dbo.Produkty),
[Cena katalogowa] -
	(SELECT AVG([Cena katalogowa]) 
	FROM dbo.Produkty)
FROM dbo.Produkty;

SELECT Z.[Nazwa produktu]
FROM dbo.Produkty AS Z
WHERE Z.[Cena katalogowa] = 
	(SELECT W.[Cena katalogowa] +4
	FROM dbo.Produkty AS W
	WHERE W.[Kod produktu]='NWTB-1'); 

SELECT [ID spedytora]
FROM dbo.Zamwienia
WHERE [ID zamwienia] BETWEEN 35 AND 37;

SELECT S.Firma
FROM dbo.Spedytorzy AS S
WHERE S.ID = 
	(SELECT Z.[ID spedytora]
	FROM dbo.Zamwienia AS Z
	WHERE Z.[ID zamwienia] BETWEEN 35 AND 37); 

SELECT S.Firma
FROM dbo.Spedytorzy AS S
WHERE S.ID IN
	(SELECT Z.[ID spedytora]
	FROM dbo.Zamwienia AS Z
	WHERE Z.[ID zamwienia] BETWEEN 35 AND 37);  

SELECT DISTINCT Z.[Wojewdztwo odbiorcy]
FROM dbo.Zamwienia AS Z
WHERE Z.[ID pracownika] IN 
	(SELECT P.ID
	FROM dbo.Pracownicy AS P
	WHERE P.[Tytu zawodowy] = 'Przedstawiciel handlowy'); 

SELECT DISTINCT Z.[Wojewdztwo odbiorcy]
FROM dbo.Zamwienia AS Z
WHERE Z.[ID pracownika] IN 
	(SELECT P.ID
	FROM dbo.Pracownicy AS P
	WHERE P.[Tytu zawodowy] = 'Programista'); 


SELECT P.Imi, P.Nazwisko
FROM dbo.Pracownicy AS P
WHERE P.ID IN 
  (SELECT  Z.[ID pracownika]
  FROM dbo.Zamwienia AS Z
  WHERE Z.[ID zamwienia] IN 
         (SELECT  SZ.[ID zamwienia]
         FROM dbo.[Szczegy zamwie] AS SZ
         WHERE SZ.[ID produktu] = 
                 (SELECT P.ID
                 FROM dbo.Produkty AS P 
                 WHERE P.[Nazwa produktu] = 'Northwind Traders Coffee'))); 

SELECT P.Nazwisko
FROM dbo.Pracownicy AS P JOIN dbo.Zamwienia AS Z 
ON P.ID=Z.[ID pracownika]
WHERE Z.[Data zamwienia] = '2006-04-05';

SELECT P.Nazwisko
FROM dbo.Pracownicy AS P
WHERE '2006-04-05' IN
	(SELECT Z.[Data zamwienia]
	FROM dbo.Zamwienia AS Z 
	WHERE P.ID=Z.[ID pracownika]);

SELECT Z.[Nazwa produktu], Z.[Cena katalogowa] 
FROM dbo.Produkty AS Z
WHERE Z.[Cena katalogowa] = 
	(SELECT MAX(W.[Cena katalogowa])
	FROM dbo.Produkty AS W);

SELECT Z.[Nazwa produktu], Z.[Cena katalogowa] 
FROM dbo.Produkty AS Z
WHERE Z.[Cena katalogowa] = 
	(SELECT MAX(W1.[Cena katalogowa])
	FROM dbo.Produkty AS W1
	WHERE W1.[Cena katalogowa] <
		(SELECT MAX(W2.[Cena katalogowa])
		FROM dbo.Produkty AS W2));

SELECT COUNT(DISTINCT [Cena katalogowa])
FROM dbo.Produkty 
WHERE [Cena katalogowa] >53;

SELECT Z.[Nazwa produktu], Z.[Cena katalogowa] 
FROM dbo.Produkty AS Z
WHERE 1 = 
	(SELECT COUNT(DISTINCT W.[Cena katalogowa])
	FROM dbo.Produkty AS W
	WHERE W.[Cena katalogowa] >Z.[Cena katalogowa]);

SELECT Z.[ID zamwienia], Z.[ID pracownika], Z.[Opata za wysyk],Z.[Data zamwienia]
FROM dbo.Zamwienia AS Z
WHERE Z.[Opata za wysyk] = 
	(SELECT MAX(W.[Opata za wysyk])
	FROM dbo.Zamwienia AS W
	WHERE W.[Data zamwienia] = Z.[Data zamwienia])
AND Z.[Data zamwienia]<'2006-06-06';

SELECT Z.[ID zamwienia], Z.[ID pracownika],'Najwysza opata w dniu:', Z.[Data zamwienia], Z.[Opata za wysyk]
FROM dbo.Zamwienia AS Z
WHERE Z.[Opata za wysyk] = 
	(SELECT MAX(W.[Opata za wysyk])
	FROM dbo.Zamwienia AS W
	WHERE W.[Data zamwienia] = Z.[Data zamwienia])
AND Z.[Data zamwienia]<'2006-06-06'
UNION ALL
SELECT Z.[ID zamwienia], Z.[ID pracownika],'Najnisza opata w dniu:',Z.[Data zamwienia], Z.[Opata za wysyk]
FROM dbo.Zamwienia AS Z
WHERE Z.[Opata za wysyk] = 
	(SELECT MIN(W.[Opata za wysyk])
	FROM dbo.Zamwienia AS W
	WHERE W.[Data zamwienia] = Z.[Data zamwienia])
AND Z.[Data zamwienia]<'2006-06-06'
ORDER BY Z.[Data zamwienia] DESC;

SELECT Z.SalesPersonID,Z.TerritoryID,Z.SalesOrderID
FROM Sales.SalesOrderHeader AS Z
WHERE NOT Z.TerritoryID = 
  (SELECT W.TerritoryID
  FROM Sales.SalesPerson AS W
  WHERE W.SalesPersonID=Z.SalesPersonID);

SELECT Z.SalesPersonID,Z.TerritoryID,W.TerritoryID,Z.SalesOrderID
FROM Sales.SalesOrderHeader AS Z
WHERE NOT Z.TerritoryID = 
  (SELECT W.TerritoryID
  FROM Sales.SalesPerson AS W
  WHERE W.SalesPersonID=Z.SalesPersonID);

SELECT Z.[ID zamwienia],Z.[ID klienta],SZ.Ilo*SZ.[Cena jednostkowa]
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE SZ.Ilo*SZ.[Cena jednostkowa] >
	(SELECT AVG(SZW.Ilo*SZW.[Cena jednostkowa])*5
	FROM dbo.Zamwienia AS ZW JOIN dbo.[Szczegy zamwie] AS SZW
	ON ZW.[ID klienta]= Z.[ID klienta]);

SELECT [Kod produktu], [Cena katalogowa], Kategoria
FROM dbo.Produkty
WHERE [Minimalna ilo do ponownego zamwienia] IS NOT NULL
AND [Cena katalogowa]>30;

SELECT W.[Kod produktu], W.[Cena katalogowa]
FROM
	(SELECT [Kod produktu], [Cena katalogowa], Kategoria
	FROM dbo.Produkty
	WHERE [Minimalna ilo do ponownego zamwienia] IS NOT NULL
	AND [Cena katalogowa]>30) AS W
WHERE W.Kategoria = 'Sosy';

SELECT 'Stanowisko: '+[Tytu zawodowy] AS Stanowisko, Wojewdztwo+ ' '+ Miasto AS Adres, COUNT(ID) AS Liczba
FROM dbo.Klienci
WHERE 'Stanowisko: '+[Tytu zawodowy] = 'Stanowisko: Kierownik ds. zakupw'
GROUP BY [Tytu zawodowy], Wojewdztwo+ ' '+ Miasto;

SELECT 'Stanowisko: '+[Tytu zawodowy] AS Stanowisko, Wojewdztwo+ ' '+ Miasto AS Adres, COUNT(ID) AS Liczba
FROM dbo.Klienci
WHERE Stanowisko = 'Stanowisko: Kierownik ds. zakupw'
GROUP BY [Tytu zawodowy], Adres;

SELECT Stanowisko,Adres,COUNT(ID) AS Liczba
FROM
	(SELECT 'Stanowisko: '+[Tytu zawodowy] AS Stanowisko, Wojewdztwo+ ' '+ Miasto AS Adres, ID
	FROM dbo.Klienci) AS W
WHERE Stanowisko = 'Stanowisko: Kierownik ds. zakupw'
GROUP BY Stanowisko, Adres;

SELECT [ID zamwienia], [Data zamwienia], [Opata za wysyk],
ROW_NUMBER() OVER(ORDER BY [Opata za wysyk] DESC) AS Numer
FROM dbo.Zamwienia;

SELECT *
FROM 
	(SELECT [ID zamwienia], [Data zamwienia], [Opata za wysyk],
	ROW_NUMBER() OVER(ORDER BY [Opata za wysyk] DESC) AS Numer
	FROM dbo.Zamwienia) AS W
WHERE Numer BETWEEN 11 AND 15;

WITH CTE1 AS
(SELECT 'Stanowisko: '+[Tytu zawodowy] AS Stanowisko, Wojewdztwo+ ' '+ Miasto AS Adres, ID
	FROM dbo.Klienci)
SELECT Stanowisko,Adres,COUNT(ID) AS Liczba
FROM CTE1
WHERE Stanowisko = 'Stanowisko: Kierownik ds. zakupw'
GROUP BY Stanowisko, Adres;

SELECT [Opata za wysyk], NTILE(5) OVER(ORDER BY  [Opata za wysyk] DESC) AS Opaty
FROM dbo.Zamwienia;

WITH przedzialy AS 
(SELECT [Opata za wysyk], NTILE(5) OVER(ORDER BY  [Opata za wysyk] DESC) AS Opaty
FROM dbo.Zamwienia)
SELECT Opaty, MIN([Opata za wysyk]), MAX([Opata za wysyk]), AVG([Opata za wysyk])
FROM przedzialy
GROUP BY Opaty
ORDER BY Opaty;

WITH lata AS
	(SELECT [ID klienta],[Opata za wysyk], MONTH([Data zamwienia]) AS Miesic
	FROM dbo.Zamwienia),
	sumy AS
		(SELECT [ID klienta], Miesic, SUM([Opata za wysyk]) AS Suma
		FROM lata
		GROUP BY [ID klienta], Miesic)
SELECT TOP 5 *
FROM sumy
ORDER BY Suma DESC;

SELECT [ID zamwienia], [Opata za wysyk]
FROM dbo.Zamwienia
WHERE NTILE(5) OVER(ORDER BY [Opata za wysyk] DESC) = 1;

WITH podzial AS 
	(SELECT [ID zamwienia], [Opata za wysyk], NTILE(5) OVER(ORDER BY [Opata za wysyk]) AS Opata
	FROM dbo.Zamwienia)
SELECT [ID zamwienia], [Opata za wysyk]
FROM podzial
WHERE Opata = 3;

WITH BezposredniPodwladni(ManagerID, Podwladni) AS 
	(SELECT ManagerID, COUNT(*)
	FROM AdventureWorks.HumanResources.Employee  
	WHERE ManagerID IS NOT NULL 
	GROUP BY ManagerID)
SELECT *
FROM BezposredniPodwladni 
ORDER BY ManagerID;

WITH Podwadni AS
	(SELECT ManagerID, EmployeeID, 1 as Pozycja
	FROM AdventureWorks.HumanResources.Employee
	WHERE ManagerID IS NULL
	UNION ALL
	SELECT E.ManagerID, E.EmployeeID, P.Pozycja+1
	FROM AdventureWorks.HumanResources.Employee AS E
	INNER JOIN Podwadni  AS P ON
	E.ManagerID = P.EmployeeID )
SELECT * FROM Podwadni
ORDER BY ManagerID;

WITH Generator AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM Generator 
WHERE i < 5000 )
SELECT i
FROM Generator
ORDER BY i; 

WITH Generator AS
(SELECT i = 1
UNION All
SELECT i = i + 1 
FROM Generator 
WHERE i < 100 )
SELECT i
FROM Generator
ORDER BY i;
GO

CREATE TABLE #SprzedazRoczna(
rok CHAR(4),
sprzedaz INT);
INSERT INTO #SprzedazRoczna (rok,sprzedaz)
VALUES('2001',100),('2002',150),('2003',120),('2004',150),('2005',250),('2006',300),('2007',250);
GO

SELECT Z.rok, Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok)) AS Trend
FROM #SprzedazRoczna AS Z;

SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z;

WITH Lata AS
(SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z)
SELECT MIN(rok), MAX(rok),Trend
FROM Lata
GROUP BY Trend;

WITH Lata AS(
SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z)
SELECT *,(SELECT COUNT(*)
         FROM Lata AS T2
         WHERE T2.rok >= T1.rok AND T2.trend <> T1.trend) AS LiczbaWierszy
FROM Lata AS T1;

WITH Lata AS(
SELECT Z.rok, SIGN(Z.sprzedaz-
  (SELECT W1.sprzedaz
  FROM #SprzedazRoczna AS W1
  WHERE W1.rok = 
         (SELECT MAX(W2.rok)
         FROM #SprzedazRoczna AS W2
         WHERE W2.rok < Z.rok))) AS Trend
FROM #SprzedazRoczna AS Z),
Czynnik AS (
SELECT *,(SELECT COUNT(*)
         FROM Lata AS T2
         WHERE T2.rok >= T1.rok AND T2.trend <> T1.trend) AS LiczbaWierszy
FROM Lata AS T1)
SELECT MIN(rok), MAX(rok),Trend
FROM Czynnik
GROUP BY LiczbaWierszy,Trend
ORDER BY MIN(rok);

SELECT Z.[Data zamwienia], SZ.[Cena jednostkowa]*SZ.Ilo
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE SZ.[Cena jednostkowa]*SZ.Ilo >= 500;

SELECT  Z.[Data zamwienia], SZ.[Cena jednostkowa]*SZ.Ilo,
	(SELECT MIN([Data zamwienia])
	FROM dbo.Zamwienia AS ZW JOIN dbo.[Szczegy zamwie] AS SZW
	ON ZW.[ID zamwienia]=SZW.[ID zamwienia]
	WHERE ZW.[Data zamwienia] > Z.[Data zamwienia]
	AND SZW.[Cena jednostkowa]*SZ.Ilo < 500) AS G
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE SZ.[Cena jednostkowa]*SZ.Ilo >= 500;

SELECT MIN([Data zamwienia]) AS DataOd, MAX([Data zamwienia]) AS DataDo,
DATEDIFF(day, MIN([Data zamwienia]), MAX([Data zamwienia])) + 1 AS Dni, MAX(Warto) 
FROM 
  (SELECT  Z.[Data zamwienia], SZ.[Cena jednostkowa]*SZ.Ilo AS Warto,
         ((SELECT MIN([Data zamwienia])
	FROM dbo.Zamwienia AS ZW JOIN dbo.[Szczegy zamwie] AS SZW
	ON ZW.[ID zamwienia]=SZW.[ID zamwienia]
	WHERE ZW.[Data zamwienia] > Z.[Data zamwienia]
	AND SZW.[Cena jednostkowa]*SZ.Ilo < 500)) AS G
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE SZ.[Cena jednostkowa]*SZ.Ilo >= 500) AS D
GROUP BY G
ORDER BY Dni DESC;

SELECT K.Nazwisko, K.Imi
FROM dbo.Klienci AS K
WHERE EXISTS 
	(SELECT * 
	FROM dbo.Zamwienia AS Z
	WHERE K.ID = Z.[ID klienta]);

SELECT K.Nazwisko, K.Imi
FROM dbo.Klienci AS K
WHERE K.ID IN 
	(SELECT Z.[ID klienta]
	FROM dbo.Zamwienia AS Z
	WHERE K.ID = Z.[ID klienta]);

SELECT P.[Kod produktu]
FROM dbo.Produkty AS P
WHERE EXISTS
	(SELECT *
	FROM dbo.[Szczegy zamwie] AS SZ
	WHERE P.ID=SZ.[ID produktu]
	AND P.[Cena katalogowa]<>SZ.[Cena jednostkowa]);

SELECT ID, Nazwisko, [Tytu zawodowy]
FROM dbo.Klienci AS K
WHERE EXISTS
	(SELECT *
	FROM dbo.Klienci AS W
	WHERE K.Nazwisko = W.Nazwisko
	AND K.[Tytu zawodowy] = W.[Tytu zawodowy]
	AND K.ID<>W.ID);

SELECT K.Nazwisko, K.Imi
FROM dbo.Klienci AS K
WHERE K.ID NOT IN 
	(SELECT Z.[ID klienta]
	FROM dbo.Zamwienia AS Z
	WHERE K.ID = Z.[ID klienta]);

SELECT Z.ID
FROM dbo.Produkty AS Z
WHERE NOT EXISTS 
	(SELECT W.ID
	FROM dbo.Produkty AS W
	WHERE W.ID = Z.ID+1);

SELECT Z.ID+1
FROM dbo.Produkty AS Z
WHERE NOT EXISTS 
  (SELECT W1.ID
	FROM dbo.Produkty AS W1
	WHERE W1.ID = Z.ID+1)
	AND ID < 
         (SELECT MAX(W2.ID)
         FROM dbo.Produkty  AS W2);

SELECT P.Nazwisko
FROM dbo.Pracownicy AS P
WHERE P.Miasto IN
  (SELECT K.Miasto
  FROM dbo.Klienci AS K);

SELECT P.Nazwisko
FROM dbo.Pracownicy AS P
WHERE P.Miasto = ANY
  (SELECT K.Miasto
  FROM dbo.Klienci AS K);

SELECT Z.[Kod produktu], Z.[Koszt standardowy]
FROM dbo.Produkty AS Z
WHERE Z.[Koszt standardowy]*10 <= ANY
  (SELECT W.[Cena katalogowa]
  FROM dbo.Produkty AS W)
ORDER BY Z.[Koszt standardowy] DESC;

SELECT TOP 1 [Cena katalogowa]
FROM dbo.Produkty 
ORDER BY [Cena katalogowa] DESC;

SELECT Z.[Kod produktu], Z.[Koszt standardowy]
FROM dbo.Produkty AS Z
WHERE EXISTS
  (SELECT *
  FROM dbo.Produkty AS W
  WHERE Z.[Koszt standardowy]*10 <=W.[Cena katalogowa])
ORDER BY Z.[Koszt standardowy] DESC;

SELECT [ID zamwienia], [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [ID klienta] = 8
ORDER BY [Opata za wysyk] DESC;

SELECT DISTINCT [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [Opata za wysyk] > ANY
  (SELECT [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [ID klienta] = 8)
ORDER BY [Opata za wysyk] DESC;

SELECT [ID zamwienia], [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [Opata za wysyk] < ANY
  (SELECT Z.[Opata za wysyk]
  FROM dbo.Zamwienia AS Z JOIN dbo.Klienci AS K
  ON Z.[ID klienta]=K.ID
  WHERE K.Miasto = 'Gdask')
ORDER BY [Opata za wysyk] DESC;

SELECT [ID zamwienia], [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [Opata za wysyk] < ANY
  (SELECT [Opata za wysyk]
	FROM dbo.Zamwienia
	WHERE [ID klienta] = 666);

SELECT [Nazwa produktu]
FROM dbo.Produkty
WHERE [Cena katalogowa] > ALL
  (SELECT [Cena katalogowa] 
  FROM dbo.Produkty
  WHERE Kategoria='Napoje');

SELECT MAX([Cena katalogowa])
FROM dbo.Produkty
WHERE Kategoria='Napoje'
GROUP BY ();

SELECT [Nazwa produktu]
FROM dbo.Produkty
WHERE [Cena katalogowa] <> ALL
	(SELECT [Cena katalogowa] 
  FROM dbo.Produkty
  WHERE Kategoria='Napoje');
  
SELECT Name
FROM Production.Product
WHERE ListPrice <> ALL
  (SELECT ListPrice
  FROM Production.Product
  WHERE ProductSubcategoryID =2);

SELECT [ID zamwienia], [Opata za wysyk]
FROM dbo.Zamwienia
WHERE [Opata za wysyk] < ALL
  (SELECT [Opata za wysyk]
	FROM dbo.Zamwienia
	WHERE [ID klienta] = 666);