USE Northwind
GO

SELECT COUNT([ID zamwienia])
FROM dbo.Zamwienia;

SELECT COUNT([ID klienta])
FROM dbo.Zamwienia;

SELECT COUNT(DISTINCT [ID klienta])
FROM dbo.Zamwienia;

SELECT DISTINCT COUNT([ID klienta])
FROM dbo.Zamwienia;

SELECT COUNT(*)
FROM dbo.Zamwienia;

SELECT COUNT(DISTINCT *)
FROM dbo.Zamwienia;

SELECT SUM([Opata za wysyk]), AVG([Opata za wysyk])
FROM dbo.Zamwienia;

CREATE TABLE #Tab
(id INT IDENTITY,
val INT);

INSERT INTO #TAB (val)
VALUES
(2),(4);


SELECT * 
FROM #TAB;

SELECT SUM(val), AVG(val) 
FROM #TAB;

INSERT INTO #TAB(val)
VALUES (NULL);

SELECT AVG(val), COUNT(*), COUNT(val)
FROM #TAB;

SELECT SUM([Cena katalogowa]), SUM(DISTINCT [Cena katalogowa])
FROM dbo.Produkty;

SELECT MIN([Data zamwienia]), MAX([Data zamwienia])
FROM dbo.Zamwienia;

SELECT MIN([Nazwa produktu]), MAX([Nazwa produktu])
FROM dbo.Produkty;

SELECT MIN(ID), MAX(ID), COUNT(*), MAX(ID)-MIN(ID)-COUNT(*)
FROM dbo.Produkty;

SELECT CHECKSUM_AGG(CAST([Koszt standardowy] AS INT))
FROM dbo.Produkty;

SELECT STDEV([Koszt standardowy])
FROM dbo.Produkty;

SELECT STDEVP([Koszt standardowy])
FROM dbo.Produkty;

SELECT VAR([Koszt standardowy])
FROM dbo.Produkty;

SELECT VARP([Koszt standardowy])
FROM dbo.Produkty;

SELECT MAX([Cena katalogowa]) - MIN([Cena katalogowa]),MAX([Cena katalogowa]) - AVG([Cena katalogowa])
FROM dbo.Produkty;

SELECT AVG([Cena katalogowa]*1.23)
FROM dbo.Produkty;

SELECT AVG([Cena katalogowa])*1.23
FROM dbo.Produkty;

SELECT MAX(AVG([Cena katalogowa]))
FROM dbo.Produkty;

SELECT AVG([Cena katalogowa])
FROM dbo.Produkty
GROUP BY Kategoria;

SELECT Kategoria, AVG([Cena katalogowa])
FROM dbo.Produkty
GROUP BY Kategoria;

SELECT Kategoria, AVG([Cena katalogowa]), [Kod produktu]
FROM dbo.Produkty
GROUP BY Kategoria;

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY [ID produktu];

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY [Kod produktu];

SELECT LEFT(Kategoria,1), AVG([Cena katalogowa])
FROM dbo.Produkty
GROUP BY LEFT(Kategoria,1);

SELECT P.Kategoria, P.[Kod produktu], AVG(SZ.Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY P.Kategoria, P.[Kod produktu];

SELECT COUNT([ID zamwienia])
FROM dbo.Zamwienia;

SELECT COUNT([ID zamwienia])
FROM dbo.Zamwienia
GROUP BY ();

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
WHERE AVG (Ilo)>10
GROUP BY [Kod produktu];

SELECT Kategoria, AVG([Cena katalogowa])
FROM dbo.Produkty
WHERE Kategoria LIKE 'S%'
GROUP BY Kategoria;

SELECT MONTH([Data zamwienia]), [ID klienta], SUM([Opata za wysyk])
FROM dbo.Zamwienia
WHERE [Typ patnoci]='Gotwka' 
GROUP BY MONTH([Data zamwienia]), [ID klienta]
ORDER BY [Data zamwienia]; 

SELECT P.Kategoria, MONTH(Z.[Data zamwienia]), SUM(SZ.[Cena jednostkowa])
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
JOIN dbo.Zamwienia AS Z 
ON SZ.[ID zamwienia]=Z.[ID zamwienia]
WHERE MONTH(Z.[Data zamwienia])<3
GROUP BY ROLLUP (P.Kategoria, MONTH(Z.[Data zamwienia]));

SELECT [Data zamwienia],[ID klienta],SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY [Data zamwienia],[ID klienta];

SELECT [Data zamwienia],[ID klienta],SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY CUBE ([Data zamwienia],[ID klienta]);

SELECT [Wojewdztwo odbiorcy],GROUPING([Wojewdztwo odbiorcy]),[Data zamwienia],GROUPING([Data zamwienia]),SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 2
GROUP BY ROLLUP ([Wojewdztwo odbiorcy],[Data zamwienia]);

SELECT GROUPING_ID([Wojewdztwo odbiorcy],[Data zamwienia]) AS [Poziom grupowania],[Wojewdztwo odbiorcy], [Data zamwienia],SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 2
GROUP BY ROLLUP ([Wojewdztwo odbiorcy],[Data zamwienia]);

SELECT [Data zamwienia], [Wojewdztwo odbiorcy], [ID klienta], SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY [Data zamwienia],[Wojewdztwo odbiorcy],[ID klienta]
UNION ALL
SELECT [Data zamwienia], [Wojewdztwo odbiorcy],NULL,SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY [Data zamwienia],[Wojewdztwo odbiorcy]
UNION ALL
SELECT [Data zamwienia],NULL,[ID klienta], SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY [Data zamwienia],[ID klienta];

SELECT [Data zamwienia], [Wojewdztwo odbiorcy], [ID klienta], SUM([Cena jednostkowa]*Ilo)
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE [ID pracownika] = 1
GROUP BY GROUPING SETS (
([Data zamwienia],[Wojewdztwo odbiorcy],[ID klienta]),
([Data zamwienia],[Wojewdztwo odbiorcy]),
([Data zamwienia],[ID klienta]));


SELECT CustomerID
FROM AdventureWorks.Sales.SalesOrderHeader
GROUP BY CustomerID
ORDER BY CustomerID

SELECT CustomerID
FROM AdventureWorks.Sales.SalesOrderHeader WITH (INDEX(0))
GROUP BY CustomerID
ORDER BY CustomerID

SELECT [Nazwa produktu], [Cena katalogowa]
FROM dbo.Produkty
WHERE Kategoria = 'Napoje';

SELECT [Nazwa produktu], [Cena katalogowa], AVG([Cena katalogowa])
FROM dbo.Produkty
WHERE Kategoria = 'Napoje';

SELECT [Nazwa produktu], [Cena katalogowa], AVG([Cena katalogowa])
FROM dbo.Produkty
WHERE Kategoria = 'Napoje'
GROUP BY [Nazwa produktu], [Cena katalogowa];

SELECT [Nazwa produktu], [Cena katalogowa], AVG([Cena katalogowa]) OVER()
FROM dbo.Produkty
WHERE Kategoria = 'Napoje';

SELECT [Nazwa produktu], [Cena katalogowa], 
AVG([Cena katalogowa]) OVER() AS rednia,
MIN([Cena katalogowa]) OVER() AS Minimum,
MAX([Cena katalogowa]) OVER() AS Maksimum
FROM dbo.Produkty
WHERE Kategoria = 'Napoje';

SELECT Kategoria
FROM dbo.Produkty;

SELECT Kategoria, 
COUNT(*) OVER (PARTITION BY Kategoria) AS LiczbaDuplikatw
FROM dbo.Produkty
ORDER BY LiczbaDuplikatw;

SELECT DISTINCT Kategoria, 
COUNT(*) OVER (PARTITION BY Kategoria) AS LiczbaProduktw
FROM dbo.Produkty
ORDER BY LiczbaProduktw;

SELECT DISTINCT Kategoria, [Cena katalogowa],
COUNT(*) OVER (PARTITION BY Kategoria,[Cena katalogowa]) AS LiczbaProduktw
FROM dbo.Produkty;

SELECT Kategoria, 
ROW_NUMBER() OVER(ORDER BY Kategoria),
RANK() OVER(ORDER BY Kategoria),
DENSE_RANK() OVER(ORDER BY Kategoria),
NTILE(3) OVER (ORDER BY Kategoria) 
FROM dbo.Produkty
WHERE [Cena katalogowa]>20;

SELECT Kategoria, [Nazwa produktu], 
ROW_NUMBER() OVER(PARTITION BY Kategoria ORDER BY [Nazwa produktu])
FROM dbo.Produkty
WHERE [Cena katalogowa]>20;

SELECT SZ.[ID produktu],MONTH(Z.[Data zamwienia]), SUM(SZ.Ilo*SZ.[Cena jednostkowa])
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE Z.[ID pracownika]=3
GROUP BY SZ.[ID produktu],MONTH(Z.[Data zamwienia])
ORDER BY SZ.[ID produktu],MONTH(Z.[Data zamwienia]);

SELECT SZ.[ID produktu],MONTH(Z.[Data zamwienia]) AS Miesic, SUM(SZ.Ilo*SZ.[Cena jednostkowa]) AS Sprzeda
INTO #TabPivot
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia]=SZ.[ID zamwienia]
WHERE Z.[ID pracownika]=3
GROUP BY SZ.[ID produktu],MONTH(Z.[Data zamwienia])
ORDER BY SZ.[ID produktu],MONTH(Z.[Data zamwienia]);

SELECT [ID produktu], [1], [2],[3], [4]
FROM #TabPivot
PIVOT ( 
SUM(Sprzeda)
FOR Miesic IN ([1], [2], [3], [4]) ) AS P
ORDER BY [ID produktu];

SELECT [ID produktu], [1], [2],[3], [4]
INTO #TabUnpivot
FROM #TabPivot
PIVOT ( 
SUM(Sprzeda)
FOR Miesic IN ([1], [2], [3], [4]) ) AS P
ORDER BY [ID produktu];

SELECT Unpiv.[ID produktu], Unpiv.Miesic, Unpiv.Sprzeda
FROM #TabUnpivot
UNPIVOT (Sprzeda FOR Miesic IN ([1], [2], [3], [4])) AS Unpiv;

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
WHERE AVG (Ilo)>10
GROUP BY [Kod produktu];

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY [Kod produktu]
HAVING AVG (Ilo)>10;

SELECT [Kod produktu], SUM(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY [Kod produktu]
HAVING Ilo=20;

SELECT [Kod produktu], AVG(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
WHERE Ilo=20
GROUP BY [Kod produktu];

SELECT [Kod produktu], AVG(Ilo)
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
GROUP BY [Kod produktu]
HAVING AVG(Ilo)=20;

SELECT Kategoria, [Minimalna ilo do ponownego zamwienia], COUNT(ID)
FROM dbo.Produkty
GROUP BY Kategoria, [Minimalna ilo do ponownego zamwienia]
HAVING [Minimalna ilo do ponownego zamwienia] IS NOT NULL;

SELECT Kategoria, [Minimalna ilo do ponownego zamwienia], COUNT(ID)
FROM dbo.Produkty
GROUP BY Kategoria, [Minimalna ilo do ponownego zamwienia]
HAVING [Minimalna ilo do ponownego zamwienia] IS NOT NULL AND COUNT(ID)>2;
