USE  Northwind
GO

SELECT [ID zamwienia], [ID spedytora]
FROM dbo.Zamwienia
WHERE [ID spedytora]=1;


SELECT dbo.Zamwienia.[ID zamwienia],dbo.Spedytorzy.Firma
FROM dbo.Zamwienia JOIN dbo.Spedytorzy
ON dbo.Zamwienia.[ID spedytora] = dbo.Spedytorzy.ID
WHERE dbo.Spedytorzy.Firma='Firma wysykowa A';


SELECT dbo.Zamwienia.[ID zamwienia],dbo.Spedytorzy.Firma
FROM dbo.Zamwienia, dbo.Spedytorzy
WHERE dbo.Zamwienia.[ID spedytora] = dbo.Spedytorzy.ID
AND dbo.Spedytorzy.Firma='Firma wysykowa A';


SELECT Firma
FROM dbo.Klienci JOIN dbo.Zamwienia
ON dbo.Klienci.ID =  dbo.Zamwienia.[ID klienta]
WHERE [ID zamwienia]=31;


SELECT dbo.Klienci.Nazwisko, dbo.Pracownicy.Nazwisko, dbo.Klienci.Miasto,dbo.Pracownicy.Miasto
FROM dbo.Klienci JOIN dbo.Pracownicy
ON dbo.Klienci.Miasto = dbo.Pracownicy.Miasto;


SELECT dbo.Klienci.ID,Klienci.Nazwisko, dbo.Pracownicy.ID,Pracownicy.Nazwisko, dbo.Klienci.Miasto,dbo.Pracownicy.Miasto
FROM dbo.Klienci JOIN dbo.Pracownicy
ON dbo.Klienci.Miasto = dbo.Pracownicy.Miasto;


SELECT ID
FROM dbo.Produkty JOIN dbo.[Szczegy zamwienia zakupu]
ON  dbo.Produkty.ID = dbo.[Szczegy zamwienia zakupu].[ID produktu];


SELECT p.ID
FROM dbo.Produkty  AS P JOIN dbo.[Szczegy zamwienia zakupu] AS S
ON  P.ID = S.[ID produktu];


SELECT Z.[ID zamwienia], SZ.[ID produktu],SZ.[ID zamwienia]
FROM dbo.Zamwienia AS Z JOIN dbo.[Szczegy zamwie] AS SZ
ON Z.[ID zamwienia] = SZ.[ID produktu];


SELECT P.[Kod produktu], p.[Cena katalowa],SZ.[Cena jednostkowa]
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.[Cena katalowa] > SZ.[Cena jednostkowa];


SELECT P.[Kod produktu], p.[Cena katalowa],SZ.[Cena jednostkowa]
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.[Cena katalowa] >= SZ.[Cena jednostkowa] AND p.ID=sz.[ID produktu];


INSERT INTO dbo.Pracownicy (Nazwisko)
VALUES ('AAA');

SELECT p.Nazwisko, Z.[Data wysania]
FROM dbo.Pracownicy AS P JOIN dbo.Zamwienia AS Z
ON P.ID=Z.[ID pracownika]
ORDER BY P.Nazwisko;


SELECT p.Nazwisko, Z.[Data wysania]
FROM dbo.Pracownicy AS P INNER JOIN dbo.Zamwienia AS Z
ON P.ID=Z.[ID pracownika]
ORDER BY P.Nazwisko;


SELECT p.Nazwisko, Z.[Data wysania]
FROM dbo.Pracownicy AS P LEFT OUTER JOIN dbo.Zamwienia AS Z
ON P.ID=Z.[ID pracownika]
ORDER BY P.Nazwisko;


SELECT p.Nazwisko
FROM dbo.Zamwienia AS Z RIGHT OUTER JOIN dbo.Pracownicy AS P
ON P.ID=Z.[ID pracownika]
WHERE Z.[ID pracownika] IS NULL;


INSERT INTO dbo.Zamwienia([ID pracownika],[Data wysania])
VALUES (NULL,GETDATE());

SELECT P.Nazwisko, Z.[Data wysania]
FROM dbo.Zamwienia AS Z FULL OUTER JOIN dbo.Pracownicy AS P
ON P.ID=Z.[ID pracownika]
WHERE Z.[ID pracownika] IS NULL OR P.ID IS NULL;

SELECT P.Nazwisko, K.Nazwisko
FROM dbo.Pracownicy AS P CROSS JOIN dbo.Klienci AS K;


SELECT DISTINCT P.Nazwisko, K.Nazwisko
FROM dbo.Pracownicy AS P CROSS JOIN dbo.Klienci AS K;


SELECT [ID transakcji], [Kod produktu]
FROM dbo.[Transakcje magazynowe] , dbo.Produkty;


SELECT [Nazwa produktu]
FROM dbo.Produkty;


SELECT P.[Nazwa produktu]
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu];


SELECT P.[Nazwa produktu], S.Firma
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
JOIN dbo.Spedytorzy AS S ON S.ID = ???


SELECT S.Firma, P.[Nazwa produktu]
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
JOIN dbo.Zamwienia AS Z ON Z.[ID zamwienia] = SZ.[ID zamwienia]
JOIN dbo.Spedytorzy AS S ON S.ID=z.[ID spedytora]
ORDER BY S.Firma;


SET SHOWPLAN_TEXT ON;

SELECT S.Firma, P.[Nazwa produktu]
FROM dbo.Produkty AS P JOIN dbo.[Szczegy zamwie] AS SZ
ON P.ID=SZ.[ID produktu]
JOIN dbo.Zamwienia AS Z ON Z.[ID zamwienia] = SZ.[ID zamwienia]
JOIN dbo.Spedytorzy AS S ON S.ID=z.[ID spedytora]
ORDER BY S.Firma;

SET SHOWPLAN_TEXT OFF;

SELECT P.Nazwisko, Z.[Data wysania]
FROM dbo.Pracownicy AS P LEFT OUTER JOIN dbo.Zamwienia AS Z
ON p.ID=z.[ID pracownika]
ORDER BY P.Nazwisko;


SELECT P.Nazwisko, Z.[Data wysania], SZ.[ID produktu]
FROM dbo.Pracownicy AS P LEFT OUTER JOIN dbo.Zamwienia AS Z
ON p.ID=z.[ID pracownika]
JOIN dbo.[Szczegy zamwie] AS SZ
ON z.[ID zamwienia]=SZ.[ID zamwienia]
ORDER BY P.Nazwisko;


SELECT P.Nazwisko, Z.[Data wysania],SZ.[ID produktu]
FROM dbo.Pracownicy AS P LEFT OUTER JOIN dbo.Zamwienia AS Z
ON p.ID=z.[ID pracownika]
LEFT OUTER JOIN dbo.[Szczegy zamwie] AS SZ
ON z.[ID zamwienia]=SZ.[ID zamwienia]
ORDER BY P.Nazwisko;


SELECT P.Nazwisko, Z.[Data wysania],SZ.[ID produktu]
FROM dbo.Pracownicy AS P LEFT OUTER JOIN (dbo.Zamwienia AS Z
JOIN dbo.[Szczegy zamwie] AS SZ
ON z.[ID zamwienia]=SZ.[ID zamwienia])
ON p.ID=z.[ID pracownika]
ORDER BY P.Nazwisko;


SELECT Firma
FROM dbo.Spedytorzy CROSS JOIN dbo.Spedytorzy;


SELECT Firma
FROM dbo.Spedytorzy AS T1 CROSS JOIN dbo.Spedytorzy AS T2;


SELECT T1.Firma
FROM dbo.Spedytorzy AS T1 CROSS JOIN dbo.Spedytorzy AS T2;


SELECT T1.[Kod produktu], T2.[Kod produktu], T1.[Cena katalowa]
FROM dbo.Produkty AS T1 JOIN dbo.Produkty AS T2
ON T1.[Cena katalowa] = T2.[Cena katalowa]
WHERE T1.[Cena katalowa] =10;


SELECT DISTINCT T1.[Kod produktu], T2.[Kod produktu], T1.[Cena katalowa]
FROM dbo.Produkty AS T1 JOIN dbo.Produkty AS T2
ON T1.[Cena katalowa] = T2.[Cena katalowa]
WHERE T1.[Cena katalowa] =10;


SELECT DISTINCT T1.[Kod produktu], T2.[Kod produktu], T1.[Cena katalowa]
FROM dbo.Produkty AS T1 JOIN dbo.Produkty AS T2
ON T1.[Cena katalowa] = T2.[Cena katalowa]
WHERE T1.[Cena katalowa] =10
AND T1.[Kod produktu]<T2.[Kod produktu]; 


USE AdventureWorks

SELECT T1.EmployeeID, T2.EmployeeID, T1.ManagerID, T2.ManagerID
FROM HumanResources.Employee T1 JOIN HumanResources.Employee T2
ON T1.ManagerID = T2.EmployeeID
WHERE T1.ManagerID=109;

USE Northwind

SELECT Firma
FROM dbo.Dostawcy
WHERE Firma LIKE '%H'
UNION 
SELECT [Kod produktu]
FROM dbo.Produkty
WHERE [Kod produktu] LIKE 'NWTB%';


SELECT Firma
FROM dbo.Dostawcy
WHERE Firma LIKE '%H'
ORDER BY Firma
UNION 
SELECT [Kod produktu]
FROM dbo.Produkty
WHERE [Kod produktu] LIKE 'NWTB%';

SELECT Firma, [Telefon subowy]
FROM dbo.Dostawcy
WHERE Firma LIKE '%H'
UNION 
SELECT [Kod produktu], [Nazwa produktu]
FROM dbo.Produkty
WHERE [Kod produktu] LIKE 'NWTB%'
ORDER BY 1;

SELECT ID
FROM dbo.Spedytorzy
UNION 
SELECT ID
FROM dbo.[Stan podatkowy zamwie];


SELECT *
FROM dbo.Spedytorzy
UNION ALL
SELECT ID
FROM dbo.[Stan podatkowy zamwie];


SELECT [ID zamwienia], [ID klienta], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [ID zamwienia] <35
OR [ID klienta] IN (4, 8);

SELECT [ID zamwienia], [ID klienta], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [ID zamwienia] <35
UNION
SELECT [ID zamwienia], [ID klienta], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [ID klienta]=4
UNION
SELECT [ID zamwienia], [ID klienta], [Data zamwienia]
FROM dbo.Zamwienia
WHERE [ID klienta]=8;


SELECT Nazwisko
FROM dbo.Klienci
INTERSECT 
SELECT Nazwisko
FROM dbo.Pracownicy;


SELECT Nazwisko
FROM dbo.Pracownicy
EXCEPT 
SELECT Nazwisko
FROM dbo.Klienci;


SELECT [Data utworzenia], Ilo, [Koszt jednostkowy], [Nazwa firmy]
FROM dbo.[Zakupy produktu]
WHERE [ID produktu]=41;

USE AdventureWorks

SELECT * 
FROM dbo.ufnGetContactInformation(1);


SELECT E.EmployeeID, F.FirstName, F.JobTitle
FROM HumanResources.Employee AS E
CROSS APPLY dbo.ufnGetContactInformation(ContactID) AS F
WHERE E. Gender = 'F'
AND E.BirthDate >'19800101'


USE Northwind

CREATE FUNCTION udfOstatnieZamowienia(@Klient AS INT, @n AS INT)
RETURNS TABLE
AS RETURN
SELECT TOP(@n) [ID zamwienia], [Data zamwienia], [Data wysania]
FROM dbo.Zamwienia
WHERE [ID klienta] = @Klient
ORDER BY [Data wysania] DESC;


SELECT *
FROM dbo.udfOstatnieZamowienia(3,2);


SELECT K.Firma, F.[Data zamwienia]
FROM dbo.Klienci AS K
CROSS APPLY udfOstatnieZamowienia(K.ID, 2) AS F
WHERE K.Miasto = 'Kielce'
ORDER BY F.[Data wysania];

SELECT K.Firma, F.[Data zamwienia]
FROM dbo.Klienci AS K
CROSS APPLY udfOstatnieZamowienia(K.ID, 1) AS F
WHERE F.[ID zamwienia] IS NULL;

SELECT K.Firma, F.[Data zamwienia]
FROM dbo.Klienci AS K
OUTER APPLY udfOstatnieZamowienia(K.ID, 1) AS F
WHERE F.[ID zamwienia] IS NULL;

