procedure DrzewoHuffmana(n:integer; Czestosci:WektorR;
                         var DrzewoH:Drzewo);
  {Utworzenie drzewa Huffmana - jest wskazywane przez DrzewoH - dla
   n czestosci danych w tablicy Czestosci (zob. rozdz. 13).
   W programie glownym nalezy zdefiniowac nastepujace typy danych:
        type Drzewo       =^Wierzcholek;
             Wierzcholek  =record
                            Waga                  :real;
                            LeweDrzewo,PraweDrzewo:Drzewo
                           end;
             TablicaDrzew =array[1..n] of Drzewo;
             WektorBy     =array[1..n] of Byte;
             WektorR      =array[1..n] of real;           }
 var a,b,Wierzch              :Drzewo;
     i,k,Poczatek,Koniec      :integer;
     WierzchCzest,WierzchDodat:TablicaDrzew;

 procedure Mniejsze(var x:Drzewo);
  {Procedura wybiera jako x wierzcholek o najmniejszej wadze.}
 begin
  if WierzchCzest[k]^.Waga<=WierzchDodat[Poczatek]^.Waga then begin
   x:=WierzchCzest[k];  
   k:=k+1
  end
  else begin
   x:=WierzchDodat[Poczatek];  
   Poczatek:=Poczatek+1
  end
 end; {Mniejsze}

begin
  {Porzadkowanie czestosci od najmniejszej algorytmem
   szybkim (quicksort).}
 QuickSort(1,n,Czestosci);
  {Utworzenie z czestosci drzew jednowierzcholkowych.}
 for i:=1 to n do begin
  New(Wierzch);  
  Wierzch^.Waga:=Czestosci[i];
  Wierzch^.LeweDrzewo:=Nil;  
  Wierzch^.PraweDrzewo:=Nil;
  WierzchCzest[i]:=Wierzch
 end;
 k:=1;  
 Poczatek:=1;  
 Koniec:=0;
 for i:=1 to n-1 do begin
  New(Wierzch);
  if i=1 then begin {Pierwsza iteracja algorytmu.}
   a:=WierzchCzest[k];  
   b:=WierzchCzest[k+1];
   k:=k+2
  end
  else begin {Dalsze iteracje.}
   if k>n then begin
     {Gdy zostal wyczerpany ciag czestosci.}
    a:=WierzchDodat[Poczatek];
    b:=WierzchDodat[Poczatek+1];
    Poczatek:=Poczatek+2
   end
   else begin
     {Oba ciagi sa niepuste.}
    Mniejsze(a);
    if k>n then begin
     b:=WierzchDodat[Poczatek];
     Poczatek:=Poczatek+1
    end
    else
     if Poczatek>Koniec then begin
      b:=WierzchCzest[k];  
      k:=k+1
     end
     else Mniejsze(b)
   end
  end;
  Koniec:=Koniec+1;
  Wierzch^.Waga:=a^.Waga+b^.Waga;
  Wierzch^.LeweDrzewo:=a;  
  Wierzch^.PraweDrzewo:=b;
  WierzchDodat[Koniec]:=Wierzch
 end;
 DrzewoH:=WierzchDodat[Koniec]
end; {DrzewoHuffmana}

procedure KodHuffmana(DrzewoH:Drzewo);
  {Procedura, ktora w pliku Wyniki zapisuje kody wierzcholkow
   wiszacych drzewa wskazanego przez DrzewoH. Typy danych
   sa takie same, jak w procedurze DrzewoHuffmana.}
 var Kod:WektorBy;  
     l  :integer;

 procedure PreOrder(DrzewoH:Drzewo);
   {Procedura rekurencyjna, ktora przeglada metoda "preorder"
    drzewo wskazane przez DrzewoH i zapisuje do pliku tekstowego
    Wyniki kody wszystkich wierzcholkow wiszacych i ich wagi.}
  var i: integer;
 begin
  if (DrzewoH^.LeweDrzewo=nil) and
     (DrzewoH^.PraweDrzewo=nil) then begin
   for i:=1 to l do write(Wyniki,Kod[i]);
   writeln(Wyniki,'   ',DrzewoH^.Waga)
  end
  else begin
   l:=l+1;  
   Kod[l]:=0;
   PreOrder(DrzewoH^.LeweDrzewo);
   l:=l+1; 
   Kod[l]:=1;
   PreOrder(DrzewoH^.PraweDrzewo)
  end;
  l:=l-1
 end;

begin
 l:=0;
 rewrite(Wyniki);
 PreOrder(DrzewoH);
 close(wyniki)
end; {KodHuffmana}
