<?php 
if ($argc != 3) {
  die("SPOSÓB UŻYCIA:skrypt8.1 <nazwa_tabeli> <nazwa pliku>\n");
}
$nazwaTabeli = $argv[1];
$nazwaPliku = $argv[2];
$liczbaWierszy = 0;

function utworz_polecenie_insert($tabela, $liczbaKolumn) {     
    $polecenie = "insert into $tabela values(";
    foreach (range(1, $liczbaKolumn) as $i) {
        $polecenie.= "?,";
    }
    $polecenie = preg_replace("/,$/", ')', $polecenie);
    return ($polecenie);
}
try {
    $db = new mysqli("localhost", "test", "test", "test");
    $db->autocommit(FALSE);
    $res = $db->prepare("select * from $nazwaTabeli");
    if ($db->errno != 0) {
        throw new Exception($db->error);
    }
    $liczbaKolumn = $res->field_count;
    $res->free_result();
    $ins = utworz_polecenie_insert($nazwaTabeli, $liczbaKolumn);
    $fmt = str_repeat("s", $liczbaKolumn);
    $res = $db->prepare($ins);
    if ($db->errno != 0) {
        throw new Exception($db->error);
    }
    $fp = new SplFileObject($nazwaPliku, "r");
    while ($wiersz = $fp->fgetcsv()) {
        if (strlen(implode('', $wiersz)) == 0) continue;
        array_unshift($wiersz, $fmt);
        foreach(range(1,$liczbaKolumn) as $i) {
            $wiersz[$i]=&$wiersz[$i];
        }
        call_user_func_array(array(&$res, "bind_param"), &$wiersz);
        $res->execute();
        if ($res->errno != 0) {
            print_r($wiersz);
            throw new Exception($res->error);
        }
        $liczbaWierszy++;
    }
    $db->commit();
    if ($db->errno != 0) {
    throw new Exception($db->error);
    }
    print "Do tabeli $nazwaTabeli wstawiono $liczbaWierszy wierszy.\n";
}
catch(Exception $e) {
print "Wyjątek:\n";
die($e->getMessage() . "\n");
} 
?>
