<?php
//przykładowe wywołanie:
//http://localhost/twitter_pin_validationtwitter_sprawdzenie_pin.php?pin=9352006

error_reporting(E_ALL ^ E_NOTICE);
require_once("twitteroauth/twitteroauth.php");
require_once("twitter_config.php");
session_start();
if ( isset( $_GET["pin"] ) ) {
    if ( is_numeric( $_GET["pin"] ) ) {
        if ( validatePIN () ) {
            print "Skrypt walidacji numeru PIN został uruchomiony.";
        }
    } else {
        print "Błąd: numer PIN nie jest liczbą.";
    }
} else {
    print "Błąd: brak podanego numeru PIN.";
}
function validatePIN() {
    //Skoro znamy tokeny żądania, możemy je przekazać do konstruktora.
    $twitterOAuth = new TwitterOAuth(
                    CONSUMER_KEY,CONSUMER_SECRET,
                    $_SESSION['request_token'], $_SESSION['request_token_secret']
    );
    //wygenerowanie tokenów dostępu {oauth_token, oauth_token_secret}
    //Wykorzystujemy numer PIN otrzymany w poprzednim kroku.
    $accessOAuthTokens = $twitterOAuth->getAccessToken( $_GET["pin"] );
    if ($accessOAuthTokens && $accessOAuthTokens['oauth_token']) {
        //zapisanie tokenów do plików
        file_put_contents( "access_token", $accessOAuthTokens['oauth_token'] );
        file_put_contents( "access_token_secret", $accessOAuthTokens['oauth_token_secret'] );
        return true;
    } else {
        print "Błąd: czas na wykorzystanie numeru PIN dobiegł końca!";
        return false;
    }
}
?>
